/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.base.GenericContainerBlock;
import pcl.common.multiblock.EnumOrientations;
import pcl.common.util.Vector3;
import pcl.lc.LanteaCraft;
import pcl.lc.blocks.BlockStargateBase;
import pcl.lc.multiblock.StargateMultiblock;
import pcl.lc.tileentity.TileEntityStargateBase;
import pcl.lc.tileentity.TileEntityStargateRing;

public class BlockStargateRing
extends GenericContainerBlock {
    static final int numSubBlocks = 2;
    public static final int subBlockMask = 1;
    Icon topAndBottomTexture;
    Icon[] sideTextures = new Icon[2];

    public BlockStargateRing(int id) {
        super(id, Block.field_71973_m[4].field_72018_cp);
        this.func_71848_c(50.0f);
        this.func_71894_b(2000.0f);
        this.func_71849_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111023_E() {
        return LanteaCraft.getAssetKey() + ":" + this.func_71917_a() + "_" + LanteaCraft.getProxy().getRenderMode();
    }

    public int func_71857_b() {
        if (LanteaCraft.Render.blockStargateRingRenderer != null) {
            return LanteaCraft.Render.blockStargateRingRenderer.renderID;
        }
        return -9001;
    }

    @Override
    public void func_94332_a(IconRegister register) {
        this.topAndBottomTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "stargateBlock_" + LanteaCraft.getProxy().getRenderMode());
        this.sideTextures[0] = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "stargateRing_" + LanteaCraft.getProxy().getRenderMode());
        this.sideTextures[1] = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "stargateChevron_" + LanteaCraft.getProxy().getRenderMode());
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public int func_71899_b(int data) {
        return data;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileEntityStargateRing te = (TileEntityStargateRing)world.func_72796_p(x, y, z);
        if (te.getAsPart().isMerged()) {
            Vector3 base = te.getAsPart().findHostMultiblock(false).getLocation();
            Block block = Block.field_71973_m[world.func_72798_a(base.floorX(), base.floorY(), base.floorZ())];
            if (block instanceof BlockStargateBase) {
                block.func_71903_a(world, base.floorX(), base.floorY(), base.floorZ(), player, side, cx, cy, cz);
            }
            return true;
        }
        return false;
    }

    public Icon func_71858_a(int side, int data) {
        if (side <= 1) {
            return this.topAndBottomTexture;
        }
        return this.sideTextures[data & 1];
    }

    public void func_71879_a(int itemID, CreativeTabs tab, List list) {
        for (int i = 0; i < 2; ++i) {
            list.add(new ItemStack(itemID, 1, i));
        }
    }

    public void func_71861_g(World world, int x, int y, int z) {
        TileEntityStargateRing te = (TileEntityStargateRing)this.getTileEntity((IBlockAccess)world, x, y, z);
        te.hostBlockPlaced();
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int id, int data) {
        TileEntityStargateRing te = (TileEntityStargateRing)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            TileEntity host;
            te.flagDirty();
            if (te.getAsPart().findHostMultiblock(false) != null && (host = te.getAsPart().findHostMultiblock(false).getTileEntity()) instanceof TileEntityStargateBase) {
                ((TileEntityStargateBase)host).hostBlockDestroyed();
            }
        }
        super.func_71852_a(world, x, y, z, id, data);
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TileEntityStargateRing();
    }

    public void func_71902_a(IBlockAccess block, int x, int y, int z) {
        TileEntity tileof = block.func_72796_p(x, y, z);
        if (tileof instanceof TileEntityStargateRing) {
            TileEntityStargateRing ring = (TileEntityStargateRing)tileof;
            if (ring.getAsPart() != null && ring.getAsPart().isMerged()) {
                StargateMultiblock master = (StargateMultiblock)ring.getAsPart().findHostMultiblock(false);
                EnumOrientations orientation = master.getOrientation();
                if (orientation != null) {
                    switch (orientation) {
                        case NORTH: 
                        case SOUTH: 
                        case NORTH_SOUTH: {
                            this.func_71905_a(0.35f, 0.0f, 0.0f, 0.65f, 1.0f, 1.0f);
                            break;
                        }
                        case EAST: 
                        case WEST: 
                        case EAST_WEST: {
                            this.func_71905_a(0.0f, 0.0f, 0.35f, 1.0f, 1.0f, 0.65f);
                            break;
                        }
                        default: {
                            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                            break;
                        }
                    }
                } else {
                    this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            } else {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

