/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.logging.Level;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.base.RotationOrientedBlock;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.tileentity.TileEntityStargateController;

public class BlockStargateController
extends RotationOrientedBlock {
    Icon topTexture;
    Icon bottomTexture;
    Icon sideTexture;

    public BlockStargateController(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.5f);
        this.func_71849_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111023_E() {
        return LanteaCraft.getAssetKey() + ":" + this.func_71917_a() + "_" + LanteaCraft.getProxy().getRenderMode();
    }

    @Override
    public void func_94332_a(IconRegister register) {
        this.topTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "controller_top_" + LanteaCraft.getProxy().getRenderMode());
        this.bottomTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "controller_bottom_" + LanteaCraft.getProxy().getRenderMode());
        this.sideTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "controller_side_" + LanteaCraft.getProxy().getRenderMode());
    }

    public Icon func_71858_a(int side, int data) {
        switch (side) {
            case 0: {
                return this.bottomTexture;
            }
            case 1: {
                return this.topTexture;
            }
        }
        return this.sideTexture;
    }

    @Override
    public int func_71857_b() {
        if (LanteaCraft.Render.blockStargateBaseRenderer != null) {
            return LanteaCraft.Render.blockControllerRenderer.renderID;
        }
        return 0;
    }

    @Override
    public boolean func_71886_c() {
        return !LanteaCraft.getProxy().isUsingModels();
    }

    public boolean func_71926_d() {
        return !LanteaCraft.getProxy().isUsingModels();
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_71860_a(world, x, y, z, player, stack);
        this.checkForLink(world, x, y, z);
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, dir, 0);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        if (player.func_70093_af() || side != ForgeDirection.UP.ordinal()) {
            if (BuildInfo.DEBUG) {
                LanteaCraft.getLogger().log(Level.INFO, "Opening StargateControllerEnergy.");
            }
            player.openGui((Object)LanteaCraft.getInstance(), LanteaCraft.EnumGUIs.StargateControllerEnergy.ordinal(), world, x, y, z);
        } else {
            if (BuildInfo.DEBUG) {
                LanteaCraft.getLogger().log(Level.INFO, "Opening StargateController.");
            }
            player.openGui((Object)LanteaCraft.getInstance(), LanteaCraft.EnumGUIs.StargateController.ordinal(), world, x, y, z);
        }
        return true;
    }

    public void checkForLink(World world, int x, int y, int z) {
        ((TileEntityStargateController)this.getTileEntity((IBlockAccess)world, x, y, z)).checkForLink();
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TileEntityStargateController();
    }

    public void func_71861_g(World world, int x, int y, int z) {
    }
}

