/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.base.RotationOrientedBlock;
import pcl.common.multiblock.EnumOrientations;
import pcl.lc.LanteaCraft;
import pcl.lc.tileentity.TileEntityStargateBase;

public class BlockStargateBase
extends RotationOrientedBlock {
    protected Icon topAndBottomTexture;
    protected Icon frontTexture;
    protected Icon sideTexture;

    public BlockStargateBase(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(50.0f);
        this.func_71894_b(2000.0f);
        this.func_71849_a(CreativeTabs.field_78026_f);
        this.func_71907_b(true);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111023_E() {
        return LanteaCraft.getAssetKey() + ":" + this.func_71917_a() + "_" + LanteaCraft.getProxy().getRenderMode();
    }

    public int func_71865_a(IBlockAccess world, int x, int y, int z, int blockID) {
        TileEntity host = world.func_72796_p(x, y, z);
        if (host instanceof TileEntityStargateBase) {
            TileEntityStargateBase base = (TileEntityStargateBase)host;
            return base.isConnected() ? 15 : 0;
        }
        return 0;
    }

    public int func_71855_c(IBlockAccess world, int x, int y, int z, int blockID) {
        TileEntity host = world.func_72796_p(x, y, z);
        if (host instanceof TileEntityStargateBase) {
            TileEntityStargateBase base = (TileEntityStargateBase)host;
            return base.isConnected() ? 15 : 0;
        }
        return 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    @Override
    public int func_71857_b() {
        if (LanteaCraft.Render.blockStargateBaseRenderer != null) {
            return LanteaCraft.Render.blockStargateBaseRenderer.renderID;
        }
        return -9001;
    }

    @Override
    public void func_94332_a(IconRegister register) {
        this.topAndBottomTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "stargateBlock_" + LanteaCraft.getProxy().getRenderMode());
        this.frontTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "stargateBase_front_" + LanteaCraft.getProxy().getRenderMode());
        this.sideTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "stargateRing_" + LanteaCraft.getProxy().getRenderMode());
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        int data = Math.round((180.0f - player.field_70177_z) / 90.0f) & 3;
        world.func_72921_c(x, y, z, data, 3);
        TileEntityStargateBase te = (TileEntityStargateBase)this.getTileEntity((IBlockAccess)world, x, y, z);
        te.hostBlockPlaced();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileEntityStargateBase te = (TileEntityStargateBase)world.func_72796_p(x, y, z);
        if (te != null && te.getAsStructure().isValid()) {
            player.openGui((Object)LanteaCraft.getInstance(), LanteaCraft.EnumGUIs.StargateBase.ordinal(), world, x, y, z);
            return true;
        }
        return false;
    }

    public Icon func_71858_a(int side, int data) {
        if (side <= 1) {
            return this.topAndBottomTexture;
        }
        if (side == 3) {
            return this.frontTexture;
        }
        return this.sideTexture;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int id, int data) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te instanceof TileEntityStargateBase) {
            ((TileEntityStargateBase)te).hostBlockDestroyed();
        }
        super.func_71852_a(world, x, y, z, id, data);
    }

    public void explode(World world, double x, double y, double z, double s) {
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TileEntityStargateBase();
    }

    public void func_71861_g(World world, int x, int y, int z) {
        TileEntity te = this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null && te instanceof TileEntityStargateBase) {
            ((TileEntityStargateBase)te).getAsStructure().invalidate();
        }
    }

    public boolean isMerged(IBlockAccess world, int x, int y, int z) {
        TileEntity te = this.getTileEntity(world, x, y, z);
        if (te != null && te instanceof TileEntityStargateBase) {
            return ((TileEntityStargateBase)te).getAsStructure().isValid();
        }
        return false;
    }

    public void func_71902_a(IBlockAccess block, int x, int y, int z) {
        TileEntity tileof = block.func_72796_p(x, y, z);
        if (tileof instanceof TileEntityStargateBase) {
            TileEntityStargateBase ring = (TileEntityStargateBase)tileof;
            if (ring.getAsStructure().getOrientation() != null) {
                EnumOrientations orientation = ring.getAsStructure().getOrientation();
                switch (orientation) {
                    case NORTH: 
                    case SOUTH: 
                    case NORTH_SOUTH: {
                        this.func_71905_a(0.35f, 0.0f, 0.0f, 0.65f, 1.0f, 1.0f);
                        break;
                    }
                    case EAST: 
                    case WEST: 
                    case EAST_WEST: {
                        this.func_71905_a(0.0f, 0.0f, 0.35f, 1.0f, 1.0f, 0.65f);
                        break;
                    }
                    default: {
                        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                }
            } else {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

