/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pcl.common.base.RotationOrientedBlock;
import pcl.lc.LanteaCraft;
import pcl.lc.tileentity.TileEntityNaquadahGenerator;

public class BlockNaquadahGenerator
extends RotationOrientedBlock {
    Icon topTexture;
    Icon bottomTexture;
    Icon sideTexture;

    public BlockNaquadahGenerator(int id) {
        super(id, Material.field_76246_e);
        this.func_71848_c(1.5f);
        this.func_71849_a(CreativeTabs.field_78026_f);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111023_E() {
        return LanteaCraft.getAssetKey() + ":" + this.func_71917_a() + "_" + LanteaCraft.getProxy().getRenderMode();
    }

    @Override
    public void func_94332_a(IconRegister register) {
        this.topTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "controller_top_" + LanteaCraft.getProxy().getRenderMode());
        this.bottomTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "controller_bottom_" + LanteaCraft.getProxy().getRenderMode());
        this.sideTexture = register.func_94245_a(LanteaCraft.getAssetKey() + ":" + "controller_side_" + LanteaCraft.getProxy().getRenderMode());
    }

    public Icon func_71858_a(int side, int data) {
        switch (side) {
            case 0: {
                return this.bottomTexture;
            }
            case 1: {
                return this.topTexture;
            }
        }
        return this.sideTexture;
    }

    @Override
    public int func_71857_b() {
        if (LanteaCraft.Render.blockNaquadahGeneratorRenderer != null) {
            return LanteaCraft.Render.blockNaquadahGeneratorRenderer.renderID;
        }
        return 0;
    }

    @Override
    public boolean func_71886_c() {
        return !LanteaCraft.getProxy().isUsingModels();
    }

    public boolean func_71926_d() {
        return !LanteaCraft.getProxy().isUsingModels();
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_71860_a(world, x, y, z, player, stack);
        int dir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, dir, 0);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        return true;
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int id, int data) {
        TileEntityNaquadahGenerator cte = (TileEntityNaquadahGenerator)this.getTileEntity((IBlockAccess)world, x, y, z);
        cte.onHostBlockBreak();
        super.func_71852_a(world, x, y, z, id, data);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileEntityNaquadahGenerator te = (TileEntityNaquadahGenerator)this.getTileEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            player.openGui((Object)LanteaCraft.getInstance(), LanteaCraft.EnumGUIs.NaquadahGenerator.ordinal(), world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public TileEntity func_72274_a(World world) {
        return new TileEntityNaquadahGenerator();
    }

    public void func_71861_g(World world, int x, int y, int z) {
    }

    public void func_71863_a(World world, int x, int y, int z, int l) {
        if (!world.field_72995_K) {
            int sig = 0;
            int a = this.isBlockProvidingPower(world, x, y + 1, z, 1);
            int b = this.isBlockProvidingPower(world, x, y - 1, z, 0);
            int c = this.isBlockProvidingPower(world, x, y, z + 1, 3);
            int d = this.isBlockProvidingPower(world, x, y, z - 1, 2);
            int e = this.isBlockProvidingPower(world, x + 1, y, z, 5);
            int f = this.isBlockProvidingPower(world, x - 1, y, z, 4);
            sig = Math.max(a, Math.max(b, Math.max(c, Math.max(d, Math.max(e, f)))));
            TileEntityNaquadahGenerator cte = (TileEntityNaquadahGenerator)this.getTileEntity((IBlockAccess)world, x, y, z);
            cte.setRedstoneInputSignal(sig);
        }
    }

    private int isBlockProvidingPower(World world, int x, int y, int z, int direction) {
        if (y >= 0 && y < world.func_72800_K()) {
            int redstoneWireValue = world.func_72798_a(x, y, z) == Block.field_72075_av.field_71990_ca ? world.func_72805_g(x, y, z) : 0;
            int indirectPowerTo = world.func_72878_l(x, y, z, direction);
            int directPowerTo = world.func_72879_k(x, y, z, direction);
            return Math.max(Math.max(redstoneWireValue, indirectPowerTo), directPowerTo);
        }
        return 0;
    }
}

