/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Property;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import pcl.common.audio.AudioEngine;
import pcl.common.base.TileEntityChunkManager;
import pcl.common.helpers.AnalyticsHelper;
import pcl.common.helpers.ConfigValue;
import pcl.common.helpers.ConfigurationHelper;
import pcl.common.helpers.GUIHandler;
import pcl.common.helpers.NetworkHelpers;
import pcl.common.helpers.RegistrationHelper;
import pcl.common.helpers.VersionHelper;
import pcl.common.network.ModPacket;
import pcl.common.util.WorldLocation;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.core.ModuleManager;
import pcl.lc.core.RemoteChunkLoading;
import pcl.lc.core.ServerTickHandler;
import pcl.lc.core.StargateConnectionManager;
import pcl.lc.core.WorldLog;
import pcl.lc.module.ModuleWorldGenerator;
import pcl.lc.module.compat.UpgradeHelper;
import pcl.lc.network.ClientPacketHandler;
import pcl.lc.network.PacketLogger;
import pcl.lc.network.ServerPacketHandler;
import pcl.lc.tileentity.TileEntityStargateBase;
import pcl.lc.tileentity.TileEntityStargateController;
import pcl.lc.worldgen.NaquadahOreWorldGen;

public class LanteaCraftCommonProxy {
    @Deprecated
    protected ConfigurationHelper config;
    @Deprecated
    protected ArrayList<ConfigValue<?>> configValues = new ArrayList();
    protected Map<String, ResourceLocation> resourceCache = new HashMap<String, ResourceLocation>();
    protected AnalyticsHelper analyticsHelper = new AnalyticsHelper(false, null);
    private VersionHelper versionHelper = new VersionHelper();
    protected ClientPacketHandler clientPacketHandler;
    protected PacketLogger clientPacketLogger;
    protected ServerPacketHandler serverPacketHandler;
    protected PacketLogger serverPacketLogger;
    private NetworkHelpers networkHelpers;
    private UpgradeHelper upgradeHelper;
    public TileEntityChunkManager chunkManager;
    protected RemoteChunkLoading remoteChunkManager;
    protected StargateConnectionManager stargateConnectionManager;
    protected AudioEngine audioContext;
    protected WorldLog worldLogger;
    private ServerTickHandler serverTickHandler = new ServerTickHandler();
    protected Map<Integer, Class<? extends Container>> registeredContainers = new HashMap<Integer, Class<? extends Container>>();
    protected Map<Integer, Class<? extends GuiScreen>> registeredGUIs = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected Map<String, VillagerMapping> registeredVillagers = new HashMap<String, VillagerMapping>();
    public int tokraVillagerID;
    protected ModuleManager moduleManager;

    public LanteaCraftCommonProxy() {
        if (BuildInfo.NET_DEBUGGING) {
            this.serverPacketLogger = new PacketLogger(new File("lc-network-server.dat"));
        }
        this.serverPacketHandler = new ServerPacketHandler(this.serverPacketLogger);
        this.networkHelpers = new NetworkHelpers();
        this.moduleManager = new ModuleManager();
    }

    public void preInit(FMLPreInitializationEvent e) {
        if (BuildInfo.isDevelopmentEnvironment()) {
            LanteaCraft.getLogger().log(Level.WARNING, "This doesn't appear to be an official build of LanteaCraft, or you are in a development context; please do not report bugs to us. We do not support external builds.");
        } else {
            LanteaCraft.getLogger().log(Level.INFO, "Hello there, I'm LanteaCraft RC1-" + BuildInfo.getBuildNumber() + "!");
        }
        this.config = new ConfigurationHelper(e.getSuggestedConfigurationFile());
        this.configure();
        this.moduleManager.preInit();
    }

    public void init(FMLInitializationEvent e) {
        LanteaCraft.getLogger().log(Level.INFO, "LanteaCraft setting up...");
        MinecraftForge.EVENT_BUS.register((Object)LanteaCraft.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)LanteaCraft.getSpecialBucketHandler());
        this.chunkManager = new TileEntityChunkManager(LanteaCraft.getInstance());
        this.remoteChunkManager = new RemoteChunkLoading();
        this.stargateConnectionManager = new StargateConnectionManager();
        this.serverTickHandler.registerTickHost(this.remoteChunkManager);
        this.serverTickHandler.registerTickHost(this.stargateConnectionManager);
        this.audioContext = new AudioEngine();
        NetworkRegistry.instance().registerGuiHandler((Object)LanteaCraft.getInstance(), (IGuiHandler)new GUIHandler());
        TickRegistry.registerTickHandler((ITickHandler)this.serverTickHandler, (Side)Side.SERVER);
        this.networkHelpers.init();
        this.moduleManager.init();
    }

    public void postInit(FMLPostInitializationEvent e) {
        RegistrationHelper.flagLateRegistrationZone();
        if (this.config.extended) {
            this.config.save();
        }
        LanteaCraft.getLogger().log(Level.INFO, "LanteaCraft done setting up!");
        LanteaCraft.getLogger().log(Level.INFO, "[COMPAT] LanteaCraft looking for other versions of SGCraft...");
        if (UpgradeHelper.detectSGCraftInstall() || UpgradeHelper.detectSGCraftReloadedInstall()) {
            this.upgradeHelper = new UpgradeHelper();
            if (UpgradeHelper.detectSGCraftInstall()) {
                this.upgradeHelper.hookSGCraft();
            }
            if (UpgradeHelper.detectSGCraftReloadedInstall()) {
                this.upgradeHelper.hookSGCraftReloaded();
            }
        }
        LanteaCraft.getLogger().log(Level.INFO, "[COMPAT] LanteaCraft done looking for other versions.");
        this.moduleManager.postInit();
    }

    public NaquadahOreWorldGen getOreGenerator() {
        if (!ModuleManager.Module.WORLDGEN.isLoaded()) {
            return null;
        }
        return ((ModuleWorldGenerator)ModuleManager.Module.WORLDGEN.moduleOf()).getNaquadahOreGenerator();
    }

    public VersionHelper getVersionHelper() {
        return this.versionHelper;
    }

    public AudioEngine getAudioEngine() {
        return this.audioContext;
    }

    public void onInitMapGen(InitMapGenEvent e) {
        LanteaCraft.getLogger().log(Level.FINE, "InitMapGenEvent fired");
    }

    void configure() {
        TileEntityStargateController.configure(this.config);
        NaquadahOreWorldGen.configure(this.config);
        TileEntityStargateBase.configure(this.config);
        this.configValues.add(new ConfigValue<Boolean>("addOresToExistingWorlds", this.config.getBoolean("options", "addOresToExistingWorlds", false)));
        String version = "RC1" + " build " + BuildInfo.getBuildNumber();
        Property prop = this.config.get("general", "currentVersion", 0);
        prop.comment = "Version cache - do not change this!";
        String previousVersion = prop.getString();
        prop.set(version);
        Property GenerateStruct = this.config.get("options", "GenerateStructures", true);
        this.configValues.add(new ConfigValue<Boolean>("doGenerateStructures", this.config.getBoolean("stargate", "GenerateStructures", true)));
        GenerateStruct.comment = "Enables/Disables generation of Gate Rooms under Desert Pyramids. (true/false)";
        Property textureRes = this.config.get("graphics_options", "textureRes", 32);
        this.configValues.add(new ConfigValue<Integer>("renderQuality", this.config.getInteger("graphics_options", "textureRes", 32)));
        textureRes.comment = "Texture resolution setting. (16 / 32 / 64 / 128)";
        Property HDModels = this.config.get("graphics_options", "HDModels", true);
        this.configValues.add(new ConfigValue<Boolean>("renderUseModels", this.config.getBoolean("graphics_options", "HDModels", true)));
        HDModels.comment = "Should HD models be used. (true/false)";
        this.configValues.add(new ConfigValue<Boolean>("doGateExplosion", this.config.getBoolean("options", "ActiveGateExplosion", true)));
        Property enableAnalytics = this.config.get("options", "enableAnalytics", true);
        this.configValues.add(new ConfigValue<Boolean>("enableAnalytics", this.config.getBoolean("options", "enableAnalytics", true)));
        enableAnalytics.comment = "Submit anonymous usage statistic data. (true/false)";
        if (version != previousVersion && enableAnalytics.getBoolean(true)) {
            this.analyticsHelper.start();
        }
        this.versionHelper.start();
    }

    void registerRecipes() {
        LanteaCraft.getLogger().log(Level.FINE, "Registering LanteaCraft recipes...");
        if (this.config.getBoolean("options", "allowCraftingNaquadah", false)) {
            // empty if block
        }
        if (this.config.getBoolean("options", "allowCraftingCrystals", false)) {
            // empty if block
        }
    }

    public ConfigValue<?> getConfigValue(String name) {
        if (BuildInfo.ASSET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.FINE, "Fetching configuration value `" + name + "`");
        }
        for (ConfigValue<?> item : this.configValues) {
            if (!item.getName().equalsIgnoreCase(name)) continue;
            return item;
        }
        return null;
    }

    public int getRenderMode() {
        int mode = (Integer)this.getConfigValue("renderQuality").getValue();
        if (mode == 16 || mode == 32 || mode == 64 || mode == 128) {
            return mode;
        }
        return 32;
    }

    public boolean isUsingModels() {
        return (Boolean)this.getConfigValue("renderUseModels").getValue();
    }

    public boolean doExplosion() {
        return (Boolean)this.getConfigValue("doGateExplosion").getValue();
    }

    @Deprecated
    private Object createGuiElement(Class<?> cls, EntityPlayer player, World world, int x, int y, int z) {
        try {
            try {
                return cls.getMethod("create", EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).invoke(null, player, world, x, y, z);
            }
            catch (NoSuchMethodException e) {
                return cls.getConstructor(EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE).newInstance(player, world, x, y, z);
            }
        }
        catch (Exception e) {
            LanteaCraft.getLogger().log(Level.SEVERE, "Failed to create GUI element, an exception occured.", e);
            return null;
        }
    }

    public int addVillager(int id, String name, ResourceLocation skin) {
        LanteaCraft.getLogger().log(Level.FINE, "Adding villager ID " + id + " with name " + name);
        this.registeredVillagers.put(name, new VillagerMapping(id, skin));
        return id;
    }

    public void addContainer(int id, Class<? extends Container> cls) {
        LanteaCraft.getLogger().log(Level.FINE, "Registering container with ID " + id + ", class " + cls.getCanonicalName());
        this.registeredContainers.put(id, cls);
    }

    public Class<? extends Container> getContainer(int id) {
        return this.registeredContainers.get(id);
    }

    public Object getGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Class<? extends GuiScreen> getGUI(int id) {
        return this.registeredGUIs.get(id);
    }

    public int getVillagerID(String name) {
        VillagerMapping villager = this.registeredVillagers.get(name);
        if (villager != null) {
            return villager.villagerID;
        }
        return 0;
    }

    public void handlePacket(ModPacket modPacket, Player player) {
        if (!modPacket.getPacketIsForServer()) {
            return;
        }
        this.serverPacketHandler.handlePacket(modPacket, player);
    }

    public void sendToServer(ModPacket packet) {
        throw new RuntimeException("Cannot send to server: this method was not overridden!!");
    }

    public void sendToAllPlayers(ModPacket packet) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            Packet250CustomPayload payload = packet.toPacket();
            payload.field_73630_a = "LanteaCraft";
            if (BuildInfo.NET_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("sendToAllPlayers: 250 %s %s", payload.field_73630_a, payload.field_73628_b));
            }
            server.func_71203_ab().func_72384_a((Packet)payload);
        }
    }

    public void sendToPlayersInDimension(ModPacket packet) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            Packet250CustomPayload payload = packet.toPacket();
            payload.field_73630_a = "LanteaCraft";
            WorldLocation origin = packet.getOriginLocation();
            if (BuildInfo.NET_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("sendToPlayersInDimension: 250 %s %s", payload.field_73630_a, payload.field_73628_b));
            }
            server.func_71203_ab().func_72396_a((Packet)payload, origin.dimension);
        }
    }

    public void sendToPlayersNear(ModPacket packet, double range) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            Packet250CustomPayload payload = packet.toPacket();
            payload.field_73630_a = "LanteaCraft";
            if (BuildInfo.NET_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("sendToPlayersNear: 250 %s %s", payload.field_73630_a, payload.field_73628_b));
            }
            WorldLocation origin = packet.getOriginLocation();
            server.func_71203_ab().func_72393_a((double)origin.x, (double)origin.y, (double)origin.z, range, origin.dimension, (Packet)payload);
        }
    }

    public void sendToPlayer(EntityPlayer player, ModPacket packet) {
        Packet250CustomPayload payload = packet.toPacket();
        payload.field_73630_a = "LanteaCraft";
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("sendToPlayer: 250 %s %s", payload.field_73630_a, payload.field_73628_b));
        }
        PacketDispatcher.sendPacketToPlayer((Packet)payload, (Player)((Player)player));
    }

    public ConfigurationHelper getConfig() {
        return this.config;
    }

    public ResourceLocation fetchResource(String resource) {
        if (!this.resourceCache.containsKey(resource)) {
            this.resourceCache.put(resource, new ResourceLocation(LanteaCraft.getAssetKey(), resource));
        }
        return this.resourceCache.get(resource);
    }

    public void onServerStarting(FMLServerStartingEvent e) {
        if (this.worldLogger != null) {
            this.worldLogger.close();
            this.worldLogger = null;
        }
        try {
            File base = new File(new File(".").getCanonicalPath());
            File datadir = new File(base, "saves/" + e.getServer().func_71270_I() + "/data").getAbsoluteFile();
            File logfile = new File(datadir, "LanteaCraft.log");
            this.worldLogger = new WorldLog(logfile);
            LanteaCraft.getLogger().log(Level.INFO, String.format("WorldLog starting: %s", logfile.toString()));
            this.worldLogger.open();
        }
        catch (IOException ioex) {
            LanteaCraft.getLogger().log(Level.WARNING, "Failed to resolve paths for WorldLog.", ioex);
        }
    }

    public void onServerStopping(FMLServerStoppingEvent e) {
        if (this.worldLogger != null) {
            LanteaCraft.getLogger().log(Level.INFO, "WorldLog shutting down...");
            this.worldLogger.close();
            this.worldLogger = null;
        }
    }

    public WorldLog getWorldLog() {
        return this.worldLogger;
    }

    public RemoteChunkLoading getRemoteChunkManager() {
        return this.remoteChunkManager;
    }

    public StargateConnectionManager getConnectionManager() {
        return this.stargateConnectionManager;
    }

    protected class VillagerMapping {
        public final int villagerID;
        public final ResourceLocation villagerSkin;

        public VillagerMapping(int id, ResourceLocation skin) {
            this.villagerID = id;
            this.villagerSkin = skin;
        }
    }
}

