/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import pcl.common.audio.ClientAudioEngine;
import pcl.common.helpers.CloakHandler;
import pcl.common.network.ModPacket;
import pcl.common.render.GenericBlockRenderer;
import pcl.common.render.RotationOrientedBlockRenderer;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;
import pcl.lc.LanteaCraftCommonProxy;
import pcl.lc.core.ClientTickHandler;
import pcl.lc.entity.EntityReplicator;
import pcl.lc.entity.EntityTokra;
import pcl.lc.guis.ScreenNaquadahGenerator;
import pcl.lc.guis.ScreenStargateBase;
import pcl.lc.guis.ScreenStargateController;
import pcl.lc.guis.ScreenStargateControllerEnergy;
import pcl.lc.guis.WrittenFontRenderer;
import pcl.lc.network.ClientPacketHandler;
import pcl.lc.network.PacketLogger;
import pcl.lc.render.blocks.BlockNaquadahGeneratorRenderer;
import pcl.lc.render.blocks.BlockStargateBaseRenderer;
import pcl.lc.render.blocks.BlockStargateControllerRenderer;
import pcl.lc.render.blocks.BlockStargateRingRenderer;
import pcl.lc.render.blocks.BlockVoidRenderer;
import pcl.lc.render.entities.EntityReplicatorRenderer;
import pcl.lc.render.entities.EntityTokraRenderer;
import pcl.lc.render.items.HeldItemRenderer;
import pcl.lc.render.models.NaquadahGeneratorModel;
import pcl.lc.render.models.RingPlatformBaseModel;
import pcl.lc.render.models.RingPlatformRingModel;
import pcl.lc.render.models.StargateControllerModel;
import pcl.lc.render.tileentity.TileEntityLanteaDecorGlassRenderer;
import pcl.lc.render.tileentity.TileEntityNaquadahGeneratorRenderer;
import pcl.lc.render.tileentity.TileEntityRingPlatformRenderer;
import pcl.lc.render.tileentity.TileEntityStargateBaseRenderer;
import pcl.lc.render.tileentity.TileEntityStargateControllerRenderer;
import pcl.lc.tileentity.TileEntityLanteaDecorGlass;
import pcl.lc.tileentity.TileEntityNaquadahGenerator;
import pcl.lc.tileentity.TileEntityRingPlatform;
import pcl.lc.tileentity.TileEntityStargateBase;
import pcl.lc.tileentity.TileEntityStargateController;

public class LanteaCraftClientProxy
extends LanteaCraftCommonProxy {
    private ClientTickHandler clientTickHandler = new ClientTickHandler();
    private ClientHooks hooks = new ClientHooks(this);
    private CloakHandler cloakHandler = new CloakHandler("http://lanteacraft.com/api/cloaks");

    public LanteaCraftClientProxy() {
        if (BuildInfo.NET_DEBUGGING) {
            this.clientPacketLogger = new PacketLogger(new File("lc-network-client.dat"));
        }
        this.clientPacketHandler = new ClientPacketHandler(this.clientPacketLogger);
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        MinecraftForge.EVENT_BUS.register((Object)this.hooks);
        this.cloakHandler.buildDatabase();
        MinecraftForge.EVENT_BUS.register((Object)this.cloakHandler);
        this.audioContext = new ClientAudioEngine();
        this.clientTickHandler.registerTickHost(this.audioContext);
        TickRegistry.registerTickHandler((ITickHandler)this.clientTickHandler, (Side)Side.CLIENT);
        this.registerScreens();
        this.registerRenderers();
    }

    public void registerScreens() {
        this.addScreen(LanteaCraft.EnumGUIs.StargateBase, ScreenStargateBase.class);
        this.addScreen(LanteaCraft.EnumGUIs.StargateController, ScreenStargateController.class);
        this.addScreen(LanteaCraft.EnumGUIs.StargateControllerEnergy, ScreenStargateControllerEnergy.class);
        this.addScreen(LanteaCraft.EnumGUIs.NaquadahGenerator, ScreenNaquadahGenerator.class);
    }

    public void registerRenderers() {
        LanteaCraft.Render.modelController = new StargateControllerModel("/assets/pcl_lc/models/dhd.obj");
        LanteaCraft.Render.modelNaquadahGenerator = new NaquadahGeneratorModel("/assets/pcl_lc/models/naquadah_generator.obj");
        LanteaCraft.Render.modelRingPlatformBase = new RingPlatformBaseModel("/assets/pcl_lc/models/transport_rings_base.obj");
        LanteaCraft.Render.modelRingPlatformRing = new RingPlatformRingModel("/assets/pcl_lc/models/transport_rings.obj");
        LanteaCraft.Render.tileEntityBaseRenderer = new TileEntityStargateBaseRenderer();
        this.addTileEntityRenderer(TileEntityStargateBase.class, LanteaCraft.Render.tileEntityBaseRenderer);
        LanteaCraft.Render.tileEntityControllerRenderer = new TileEntityStargateControllerRenderer();
        this.addTileEntityRenderer(TileEntityStargateController.class, LanteaCraft.Render.tileEntityControllerRenderer);
        LanteaCraft.Render.tileEntityNaquadahGeneratorRenderer = new TileEntityNaquadahGeneratorRenderer();
        this.addTileEntityRenderer(TileEntityNaquadahGenerator.class, LanteaCraft.Render.tileEntityNaquadahGeneratorRenderer);
        LanteaCraft.Render.tileEntityRingPlatformRenderer = new TileEntityRingPlatformRenderer();
        this.addTileEntityRenderer(TileEntityRingPlatform.class, LanteaCraft.Render.tileEntityRingPlatformRenderer);
        LanteaCraft.Render.tileEntityLanteaDecorGlassRenderer = new TileEntityLanteaDecorGlassRenderer();
        this.addTileEntityRenderer(TileEntityLanteaDecorGlass.class, LanteaCraft.Render.tileEntityLanteaDecorGlassRenderer);
        LanteaCraft.Render.blockOrientedRenderer = new RotationOrientedBlockRenderer();
        this.registerRenderer(LanteaCraft.Render.blockOrientedRenderer);
        LanteaCraft.Render.blockStargateBaseRenderer = new BlockStargateBaseRenderer();
        this.registerRenderer(LanteaCraft.Render.blockStargateBaseRenderer);
        LanteaCraft.Render.blockStargateRingRenderer = new BlockStargateRingRenderer();
        this.registerRenderer(LanteaCraft.Render.blockStargateRingRenderer);
        LanteaCraft.Render.blockControllerRenderer = new BlockStargateControllerRenderer();
        this.registerRenderer(LanteaCraft.Render.blockControllerRenderer);
        LanteaCraft.Render.blockNaquadahGeneratorRenderer = new BlockNaquadahGeneratorRenderer();
        this.registerRenderer(LanteaCraft.Render.blockNaquadahGeneratorRenderer);
        LanteaCraft.Render.blockVoidRenderer = new BlockVoidRenderer();
        this.registerRenderer(LanteaCraft.Render.blockVoidRenderer);
        LanteaCraft.Render.heldItemRenderer = new HeldItemRenderer();
        MinecraftForgeClient.registerItemRenderer((int)LanteaCraft.Items.gdo.field_77779_bT, (IItemRenderer)LanteaCraft.Render.heldItemRenderer);
        LanteaCraft.Render.entityTokraRenderer = new EntityTokraRenderer();
        RenderingRegistry.registerEntityRenderingHandler(EntityTokra.class, (Render)LanteaCraft.Render.entityTokraRenderer);
        LanteaCraft.Render.entityReplicatorRenderer = new EntityReplicatorRenderer();
        RenderingRegistry.registerEntityRenderingHandler(EntityReplicator.class, (Render)LanteaCraft.Render.entityReplicatorRenderer);
        LanteaCraft.Render.danielFontRenderer = new WrittenFontRenderer(LanteaCraft.getResource("textures/notebook/daniel.png"), LanteaCraft.getResource("textures/notebook/daniel.metrics.xml"));
        LanteaCraft.Render.danielFontRenderer.buildFont();
    }

    void addTileEntityRenderer(Class<? extends TileEntity> teClass, TileEntitySpecialRenderer renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(teClass, (TileEntitySpecialRenderer)renderer);
    }

    void registerRenderer(GenericBlockRenderer renderer) {
        renderer.renderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)renderer);
    }

    void addScreen(Enum<?> id, Class<? extends GuiScreen> cls) {
        this.registeredGUIs.put(id.ordinal(), cls);
    }

    public void spawnEffect(EntityFX effect) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(effect);
    }

    @Override
    public Object getGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        LanteaCraft.getLogger().log(Level.FINE, String.format("Initializing GUI with ordinal %s.", ID));
        Class<? extends GuiScreen> gui = LanteaCraft.getProxy().getGUI(ID);
        if (gui != null) {
            try {
                LanteaCraft.getLogger().log(Level.FINE, String.format("Initializing GUI of class %s.", gui.getName()));
                TileEntity entity = world.func_72796_p(x, y, z);
                Constructor<? extends GuiScreen> constr = gui.getConstructor(entity.getClass(), EntityPlayer.class);
                GuiScreen val = constr.newInstance(entity, player);
                return val;
            }
            catch (Throwable t) {
                LanteaCraft.getLogger().log(Level.SEVERE, String.format("Failed to create GUI with ID %s", ID), t);
            }
        }
        return null;
    }

    @Override
    public void handlePacket(ModPacket packet, Player player) {
        if (packet.getPacketIsForServer()) {
            this.serverPacketHandler.handlePacket(packet, player);
        } else {
            this.clientPacketHandler.handlePacket(packet, player);
        }
    }

    @Override
    public void sendToServer(ModPacket packet) {
        Packet250CustomPayload payload = packet.toPacket();
        payload.field_73630_a = "LanteaCraft";
        if (BuildInfo.NET_DEBUGGING) {
            LanteaCraft.getLogger().log(Level.INFO, String.format("sendToServer: 250 %s %s", payload.field_73630_a, payload.field_73628_b));
        }
        FMLClientHandler.instance().sendPacket((Packet)payload);
    }

    private void movePlayerToServer(String address, int port) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.func_72882_A();
        mc.func_71367_a(address, port);
    }

    public static class ClientHooks {
        private boolean shownStatGui = false;
        private LanteaCraftClientProxy proxy;

        public ClientHooks(LanteaCraftClientProxy proxy) {
            this.proxy = proxy;
        }

        @ForgeSubscribe
        public void openMainMenu(GuiOpenEvent event) {
            if (event.gui instanceof GuiMainMenu && !this.shownStatGui) {
                this.shownStatGui = true;
            }
        }
    }
}

