/*
 * Decompiled with CFR 0.152.
 */
package pcl.lc;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.WorldEvent;
import pcl.common.helpers.CreativeTabHelper;
import pcl.common.helpers.SpecialBucketHandler;
import pcl.common.render.RotationOrientedBlockRenderer;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraftCommonProxy;
import pcl.lc.blocks.BlockLanteaOre;
import pcl.lc.blocks.BlockNaquadahGenerator;
import pcl.lc.blocks.BlockOfLanteaOre;
import pcl.lc.blocks.BlockRingPlatform;
import pcl.lc.blocks.BlockStargateBase;
import pcl.lc.blocks.BlockStargateController;
import pcl.lc.blocks.BlockStargateRing;
import pcl.lc.entity.EntityReplicator;
import pcl.lc.entity.EntityTokra;
import pcl.lc.fluids.BlockLiquidNaquadah;
import pcl.lc.fluids.ItemSpecialBucket;
import pcl.lc.fluids.LiquidNaquadah;
import pcl.lc.guis.WrittenFontRenderer;
import pcl.lc.items.ItemControllerCrystal;
import pcl.lc.items.ItemCoreCrystal;
import pcl.lc.items.ItemDebugTool;
import pcl.lc.items.ItemEnergyCrystal;
import pcl.lc.items.ItemGDO;
import pcl.lc.items.ItemIris;
import pcl.lc.items.ItemJacksonNotebook;
import pcl.lc.items.ItemLanteaOre;
import pcl.lc.items.ItemLanteaOreIngot;
import pcl.lc.items.ItemTokraSpawnEgg;
import pcl.lc.items.ItemTransportRingActivator;
import pcl.lc.items.ItemZPM;
import pcl.lc.network.DefaultPacketHandler;
import pcl.lc.render.blocks.BlockNaquadahGeneratorRenderer;
import pcl.lc.render.blocks.BlockStargateBaseRenderer;
import pcl.lc.render.blocks.BlockStargateControllerRenderer;
import pcl.lc.render.blocks.BlockStargateRingRenderer;
import pcl.lc.render.blocks.BlockVoidRenderer;
import pcl.lc.render.entities.EntityReplicatorRenderer;
import pcl.lc.render.entities.EntityTokraRenderer;
import pcl.lc.render.items.HeldItemRenderer;
import pcl.lc.render.models.NaquadahGeneratorModel;
import pcl.lc.render.models.RingPlatformBaseModel;
import pcl.lc.render.models.RingPlatformRingModel;
import pcl.lc.render.models.StargateControllerModel;
import pcl.lc.render.tileentity.TileEntityLanteaDecorGlassRenderer;
import pcl.lc.render.tileentity.TileEntityNaquadahGeneratorRenderer;
import pcl.lc.render.tileentity.TileEntityRingPlatformRenderer;
import pcl.lc.render.tileentity.TileEntityStargateBaseRenderer;
import pcl.lc.render.tileentity.TileEntityStargateControllerRenderer;

@Mod(modid="LanteaCraft", name="LanteaCraft", version="RC1-37", dependencies="after:ComputerCraft;after:OpenComputers;after:BuildCraft|Core;after:IC2;after:SGCraft")
@NetworkMod(clientSideRequired=true, serverSideRequired=true, channels={"LanteaCraft"}, packetHandler=DefaultPacketHandler.class)
public class LanteaCraft {
    private static LanteaCraft mod;
    private static Logger logger;
    private static CreativeTabHelper lanteaCraftTab;
    @SidedProxy(clientSide="pcl.lc.LanteaCraftClientProxy", serverSide="pcl.lc.LanteaCraftCommonProxy")
    public static LanteaCraftCommonProxy proxy;
    private SpecialBucketHandler bucketHandler = new SpecialBucketHandler();
    private String assetKey = "pcl_lc";

    public static LanteaCraft getInstance() {
        return mod;
    }

    public static Logger getLogger() {
        return logger;
    }

    public LanteaCraft() {
        mod = this;
    }

    public static ResourceLocation getResource(String path) {
        return LanteaCraft.getProxy().fetchResource(path);
    }

    public static LanteaCraftCommonProxy getProxy() {
        return proxy;
    }

    public static String getAssetKey() {
        return LanteaCraft.getInstance().assetKey;
    }

    public static CreativeTabs getCreativeTab() {
        LanteaCraft.getInstance();
        return lanteaCraftTab;
    }

    public static SpecialBucketHandler getSpecialBucketHandler() {
        return LanteaCraft.getInstance().bucketHandler;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        logger.setParent(FMLLog.getLogger());
        logger.setLevel(Level.INFO);
        if (BuildInfo.isDevelopmentEnvironment()) {
            logger.setLevel(Level.ALL);
        }
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @ForgeSubscribe
    public void onInitMapGen(InitMapGenEvent e) {
        proxy.onInitMapGen(e);
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        proxy.onServerStarting(e);
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent e) {
        proxy.onServerStopping(e);
    }

    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload evt) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("World unloading: %s", evt.world.field_73011_w.field_76574_g));
    }

    @ForgeSubscribe
    public void onWorldLoad(WorldEvent.Load evt) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("World loading: %s", evt.world.field_73011_w.field_76574_g));
    }

    static {
        lanteaCraftTab = new CreativeTabHelper(CreativeTabs.getNextID(), "LanteaCraft"){

            public ItemStack getIconItemStack() {
                return new ItemStack((Item)Items.debugger);
            }
        };
    }

    public static enum EnumGUIs {
        StargateBase,
        StargateController,
        StargateControllerEnergy,
        NaquadahGenerator;

    }

    public static class Entities {
        public static EntityTokra entityTokra;
        public static EntityReplicator entityReplicator;
    }

    public static class Fluids {
        public static LiquidNaquadah fluidLiquidNaquadah;
        public static BlockLiquidNaquadah fluidLiquidNaquadahHost;
        public static ItemSpecialBucket fluidLiquidNaquadahBucket;
    }

    public static class Render {
        public static StargateControllerModel modelController;
        public static NaquadahGeneratorModel modelNaquadahGenerator;
        public static RingPlatformBaseModel modelRingPlatformBase;
        public static RingPlatformRingModel modelRingPlatformRing;
        public static RotationOrientedBlockRenderer blockOrientedRenderer;
        public static BlockVoidRenderer blockVoidRenderer;
        public static BlockStargateBaseRenderer blockStargateBaseRenderer;
        public static BlockStargateRingRenderer blockStargateRingRenderer;
        public static BlockStargateControllerRenderer blockControllerRenderer;
        public static BlockNaquadahGeneratorRenderer blockNaquadahGeneratorRenderer;
        public static TileEntityStargateBaseRenderer tileEntityBaseRenderer;
        public static TileEntityStargateControllerRenderer tileEntityControllerRenderer;
        public static TileEntityNaquadahGeneratorRenderer tileEntityNaquadahGeneratorRenderer;
        public static TileEntityRingPlatformRenderer tileEntityRingPlatformRenderer;
        public static TileEntityLanteaDecorGlassRenderer tileEntityLanteaDecorGlassRenderer;
        public static HeldItemRenderer heldItemRenderer;
        public static WrittenFontRenderer danielFontRenderer;
        public static EntityTokraRenderer entityTokraRenderer;
        public static EntityReplicatorRenderer entityReplicatorRenderer;
    }

    public static class Items {
        public static ItemLanteaOre lanteaOreItem;
        public static ItemLanteaOreIngot lanteaOreIngot;
        public static ItemCoreCrystal coreCrystal;
        public static ItemControllerCrystal controllerCrystal;
        public static ItemEnergyCrystal energyCrystal;
        public static ItemZPM zpm;
        public static ItemIris iris;
        public static ItemGDO gdo;
        public static ItemTransportRingActivator transportRingActivator;
        public static ItemTokraSpawnEgg tokraSpawnEgg;
        public static ItemJacksonNotebook jacksonNotebook;
        public static ItemDebugTool debugger;
    }

    public static class Blocks {
        public static BlockStargateBase stargateBaseBlock;
        public static BlockStargateRing stargateRingBlock;
        public static BlockStargateController stargateControllerBlock;
        public static BlockLanteaOre lanteaOre;
        public static BlockOfLanteaOre lanteaOreAsBlock;
        public static BlockRingPlatform ringPlatform;
        public static BlockNaquadahGenerator naquadahGenerator;
    }
}

