/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.xmlcfg;

import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import pcl.common.xmlcfg.ConfigList;
import pcl.common.xmlcfg.ConfigNode;
import pcl.common.xmlcfg.ModuleConfig;
import pcl.common.xmlcfg.XMLSaverException;

public class XMLSaver {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public XMLSaver() {
        this.factory.setValidating(false);
    }

    public void save(ConfigList list) throws XMLSaverException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            this.saveObject(doc, list);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StringWriter out = new StringWriter();
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new XMLSaverException("Can't save; configuration exception.", e);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLSaverException("Can't save; TransformerConfigurationException occured.", e);
        }
        catch (TransformerException e) {
            throw new XMLSaverException("Can't save; TransformerException occured.", e);
        }
    }

    private void saveObject(Document document, ConfigNode node) throws XMLSaverException {
        if (!(node instanceof ModuleConfig)) {
            if (node instanceof ConfigList) {
                this.saveConfigList(document, (ConfigList)node);
            } else {
                this.saveConfigNode(document, node);
            }
        }
    }

    private void saveModuleConfig(Document document, ModuleConfig container) throws XMLSaverException {
    }

    private void saveConfigNode(Document document, ConfigNode nodeOf) throws XMLSaverException {
    }

    private void saveConfigList(Document document, ConfigList listOf) throws XMLSaverException {
    }
}

