/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.xmlcfg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pcl.common.xmlcfg.ConfigList;
import pcl.common.xmlcfg.ConfigNode;
import pcl.common.xmlcfg.DOMHelper;
import pcl.common.xmlcfg.ModuleConfig;
import pcl.common.xmlcfg.XMLParserException;

public class XMLParser {
    private final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public ConfigList read(InputStream chunk) throws XMLParserException {
        try {
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document doc = builder.parse(chunk);
            NodeList root = doc.getDocumentElement().getChildNodes();
            Node modRoot = DOMHelper.findNode(root, "ModConfig", false);
            if (modRoot == null) {
                throw new XMLParserException("Missing ModConfig root tag.");
            }
            return this.readRoot(modRoot);
        }
        catch (IOException e) {
            throw new XMLParserException("Can't parse; IOException occured.", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLParserException("Can't parse; configuration exception.", e);
        }
        catch (SAXException e) {
            throw new XMLParserException("Can't parse; document syntax exception.", e);
        }
    }

    private ConfigList readRoot(Node modRoot) throws XMLParserException {
        ConfigList root = new ConfigList("ModConfig");
        ArrayList<ModuleConfig> rootChildren = new ArrayList<ModuleConfig>();
        NodeList childrenRoot = modRoot.getChildNodes();
        for (int i = 0; i < childrenRoot.getLength(); ++i) {
            Node child = childrenRoot.item(i);
            if (!DOMHelper.isNodeOfType(child, "Module", false)) continue;
            rootChildren.add(this.readModuleConfig((Element)child));
        }
        return root;
    }

    private ModuleConfig readModuleConfig(Element moduleNode) throws XMLParserException {
        DOMHelper.checkedAllAttributes(moduleNode, new String[]{"name", "enabled"});
        ModuleConfig moduleRoot = new ModuleConfig(moduleNode.getAttribute("name"));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        ArrayList<ConfigNode> rootChildren = new ArrayList<ConfigNode>();
        parameters.put("enabled", DOMHelper.popBoolean(moduleNode.getAttribute("enabled"), false));
        NodeList childrenRoot = moduleNode.getChildNodes();
        for (int i = 0; i < childrenRoot.getLength(); ++i) {
            Node child = childrenRoot.item(i);
            if (!(child instanceof Element)) continue;
            rootChildren.add(this.readRecusriveObject((Element)child));
        }
        moduleRoot.setParameters(parameters);
        moduleRoot.setChildren(rootChildren);
        return moduleRoot;
    }

    private ConfigNode readRecusriveObject(Element element) throws XMLParserException {
        if (element.hasChildNodes()) {
            ConfigList group = new ConfigList(element.getTagName());
            ArrayList<ConfigNode> childrenGroup = new ArrayList<ConfigNode>();
            if (element.hasAttributes()) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                NamedNodeMap nodes = element.getAttributes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    System.out.println(String.format("readRecursive ConfigList, node: %s", node.toString()));
                }
                group.setParameters(parameters);
            }
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                childrenGroup.add(this.readRecusriveObject((Element)child));
            }
            group.setChildren(childrenGroup);
            return group;
        }
        ConfigNode single = new ConfigNode(element.getTagName());
        if (element.hasAttributes()) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            NamedNodeMap nodes = element.getAttributes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                System.out.println(String.format("readRecursive ConfigNode, node: %s", node.toString()));
            }
            single.setParameters(parameters);
        }
        return single;
    }
}

