/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.xmlcfg;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pcl.common.xmlcfg.XMLParserException;

public class DOMHelper {
    public static boolean isNodeOfType(Node node, String tagName, boolean caseSensitive) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element nodeAsElement = (Element)node;
        if (caseSensitive && nodeAsElement.getTagName().equals(tagName)) {
            return true;
        }
        return !caseSensitive && nodeAsElement.getTagName().equalsIgnoreCase(tagName);
    }

    public static Node findNode(NodeList list, String tagName, boolean caseSensitive) {
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!DOMHelper.isNodeOfType(node, tagName, caseSensitive)) continue;
            return node;
        }
        return null;
    }

    public static Node[] findNodesOf(NodeList list, String tagName, boolean caseSensitive) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!DOMHelper.isNodeOfType(node, tagName, caseSensitive)) continue;
            result.add(node);
        }
        return result.toArray(new Node[0]);
    }

    public static boolean hasAllAttributes(Element element, String[] labels) {
        for (String label : labels) {
            if (element.hasAttribute(label)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyAttributes(Element element, String[] labels) {
        for (String label : labels) {
            if (!element.hasAttribute(label)) continue;
            return true;
        }
        return false;
    }

    public static void checkedAllAttributes(Element element, String[] labels) throws XMLParserException {
        for (String label : labels) {
            if (element.hasAttribute(label)) continue;
            throw new XMLParserException(String.format("Tag %s missing attribute %s.", element.getNodeName(), label));
        }
    }

    public static void checkedAnyAttributes(Element element, String[] labels) throws XMLParserException {
        for (String label : labels) {
            if (!element.hasAttribute(label)) continue;
            return;
        }
        throw new XMLParserException(String.format("Tag %s missing at least one of any attribute: %s.", element.getNodeName(), DOMHelper.listToString(labels)));
    }

    private static String listToString(String[] labels) {
        StringBuilder s = new StringBuilder();
        for (String j : labels) {
            s.append(j).append(", ");
        }
        String s1 = s.toString();
        return s1.substring(0, s1.length() - 2);
    }

    private static String listToString(List<String> labels) {
        return DOMHelper.listToString(labels.toArray(new String[0]));
    }

    public static boolean popBoolean(String input, boolean caseSensitive) {
        String[] legals;
        for (String legal : legals = new String[]{"1", "true", "on", "yes", "enabled"}) {
            if (caseSensitive && input.equals(legal)) {
                return true;
            }
            if (caseSensitive || !input.equalsIgnoreCase(legal)) continue;
            return true;
        }
        return false;
    }
}

