/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.util;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.ForgeDirection;

public class Vector3 {
    public static final Vector3 zero = new Vector3(0.0, 0.0, 0.0);
    public static final Vector3 unitX = new Vector3(1.0, 0.0, 0.0);
    public static final Vector3 unitY = new Vector3(0.0, 1.0, 0.0);
    public static final Vector3 unitZ = new Vector3(0.0, 0.0, 1.0);
    public static final Vector3 unitNX = new Vector3(-1.0, 0.0, 0.0);
    public static final Vector3 unitNY = new Vector3(0.0, -1.0, 0.0);
    public static final Vector3 unitNZ = new Vector3(0.0, 0.0, -1.0);
    public static final Vector3 unitPXPY = new Vector3(0.707, 0.707, 0.0);
    public static final Vector3 unitPYPZ = new Vector3(0.0, 0.707, 0.707);
    public static final Vector3 unitPYNZ = new Vector3(0.0, 0.707, -0.707);
    public static final Vector3 unitPYNX = new Vector3(-0.707, 0.707, 0.0);
    public double x;
    public double y;
    public double z;

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(Vec3 v) {
        this(v.field_72450_a, v.field_72448_b, v.field_72449_c);
    }

    public Vector3(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public Vector3(TileEntity tileentity) {
        this(tileentity.field_70329_l, tileentity.field_70330_m, tileentity.field_70327_n);
    }

    public Vector3(ForgeDirection direction) {
        this(direction.offsetX, direction.offsetY, direction.offsetZ);
    }

    public Vector3(NBTTagCompound compound) {
        if (!(compound.func_74764_b("x") && compound.func_74764_b("y") && compound.func_74764_b("z"))) {
            throw new IllegalArgumentException("Compound is not a packed Vector3!");
        }
        new Vector3(compound.func_74769_h("x"), compound.func_74769_h("y"), compound.func_74769_h("z"));
    }

    public Vec3 toVec3() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound comp = new NBTTagCompound();
        comp.func_74780_a("x", this.x);
        comp.func_74780_a("y", this.y);
        comp.func_74780_a("z", this.z);
        return comp;
    }

    public String toString() {
        return "Vector3(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    public Vector3 add(double x, double y, double z) {
        return new Vector3(this.x + x, this.y + y, this.z + z);
    }

    public Vector3 add(Vector3 v) {
        return this.add(v.x, v.y, v.z);
    }

    public Vector3 add(ForgeDirection direction) {
        return new Vector3(this.x + (double)direction.offsetX, this.y + (double)direction.offsetY, this.z + (double)direction.offsetZ);
    }

    public Vector3 sub(double x, double y, double z) {
        return new Vector3(this.x - x, this.y - y, this.z - z);
    }

    public Vector3 sub(Vector3 v) {
        return this.sub(v.x, v.y, v.z);
    }

    public Vector3 mul(double c) {
        return new Vector3(c * this.x, c * this.y, c * this.z);
    }

    public Vector3 div(double c) {
        return new Vector3(this.x / c, this.y / c, this.z / c);
    }

    public double dot(Vector3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Vector3 min(Vector3 v) {
        return new Vector3(Math.min(this.x, v.x), Math.min(this.y, v.y), Math.min(this.z, v.z));
    }

    public Vector3 max(Vector3 v) {
        return new Vector3(Math.max(this.x, v.x), Math.max(this.y, v.y), Math.max(this.z, v.z));
    }

    public double distanceTo(Vector3 v) {
        double dx = this.x - v.x;
        double dy = this.y - v.y;
        double dz = this.z - v.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double mag() {
        return Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public Vector3 unitV() {
        return new Vector3(this.x / this.mag(), this.y / this.mag(), this.z / this.mag());
    }

    public int floorX() {
        return (int)Math.floor(this.x);
    }

    public int floorY() {
        return (int)Math.floor(this.y);
    }

    public int floorZ() {
        return (int)Math.floor(this.z);
    }

    public float anglePNorm(Vector3 mul) {
        return (float)Math.acos(this.dot(mul));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Vector3)) {
            return false;
        }
        Vector3 that = (Vector3)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }
}

