/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.util;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import pcl.common.util.WorldLocation;

public class ChunkLocation {
    public int dimension;
    public int cx;
    public int cz;
    public boolean isStrongLocation;

    public ChunkLocation(TileEntity te) {
        this(te.field_70331_k.field_73011_w.field_76574_g, te.field_70329_l >> 4, te.field_70327_n >> 4);
    }

    public ChunkLocation(int dimension, int x, int z) {
        this.dimension = dimension;
        this.cx = x;
        this.cz = z;
        this.isStrongLocation = true;
    }

    public ChunkLocation(int x, int z) {
        this.cx = x;
        this.cz = z;
        this.isStrongLocation = false;
    }

    public ChunkLocation(NBTTagCompound nbt) {
        this.dimension = nbt.func_74762_e("dimension");
        this.cx = nbt.func_74762_e("cx");
        this.cz = nbt.func_74762_e("cz");
        this.isStrongLocation = nbt.func_74767_n("isStrongLocation");
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("dimension", this.dimension);
        nbt.func_74768_a("cx", this.cx);
        nbt.func_74768_a("cz", this.cz);
        nbt.func_74757_a("isStrongLocation", this.isStrongLocation);
        return nbt;
    }

    public WorldLocation toWorldLocation() {
        if (!this.isStrongLocation) {
            throw new IllegalArgumentException("Can't make a weak location a WorldLocation!");
        }
        return new WorldLocation(this.dimension, this.cx << 4, 0, this.cz << 4);
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.isStrongLocation = true;
    }

    public void clearDimension() {
        this.dimension = 0;
        this.isStrongLocation = false;
    }
}

