/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.network;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.network.packet.Packet250CustomPayload;
import pcl.common.network.IStreamPackable;
import pcl.common.network.ModPacket;
import pcl.common.util.WorldLocation;

public class TinyModPacket
extends ModPacket {
    private DataInputStream instream;
    private DataOutputStream outstream;
    private ByteArrayOutputStream outbuff;
    private WorldLocation origin;
    private boolean toServer = false;

    public static TinyModPacket createPacket(DataInputStream data) throws IOException {
        boolean isServer = data.readByte() == 1;
        IStreamPackable<?> unpacker = ModPacket.findPacker(WorldLocation.class);
        WorldLocation location = (WorldLocation)unpacker.unpack(data);
        TinyModPacket pkt = new TinyModPacket(data, location);
        pkt.setIsForServer(isServer);
        return pkt;
    }

    public TinyModPacket(WorldLocation creationOrigin) {
        this.outbuff = new ByteArrayOutputStream();
        this.outstream = new DataOutputStream(this.outbuff);
        this.origin = creationOrigin;
    }

    public TinyModPacket(DataInputStream data, WorldLocation sourceOrigin) {
        this.instream = data;
        this.origin = sourceOrigin;
    }

    @Override
    public WorldLocation getOriginLocation() {
        return this.origin;
    }

    public DataInputStream getIn() {
        return this.instream;
    }

    public DataOutputStream getOut() {
        return this.outstream;
    }

    public void setIsForServer(boolean b) {
        this.toServer = b;
    }

    @Override
    public boolean getPacketIsForServer() {
        return this.toServer;
    }

    @Override
    public Packet250CustomPayload toPacket() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Packet250CustomPayload pkt = new Packet250CustomPayload();
        try {
            bytes.write(1);
            bytes.write(this.toServer ? 1 : 0);
            IStreamPackable<?> packer = ModPacket.findPacker(WorldLocation.class);
            DataOutputStream wrapper = new DataOutputStream(bytes);
            packer.pack(this.origin, wrapper);
            wrapper.flush();
            wrapper.close();
            this.outstream.flush();
            this.outstream.close();
            bytes.write(this.outbuff.toByteArray());
        }
        catch (IOException e) {
            Logger.getLogger("pcl.common").log(Level.WARNING, "Exception when writing packet!", e);
        }
        pkt.field_73629_c = bytes.toByteArray();
        pkt.field_73628_b = pkt.field_73629_c.length;
        return pkt;
    }

    @Override
    public String getType() {
        return "TinyPacket";
    }
}

