/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.network;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.network.packet.Packet250CustomPayload;
import pcl.common.network.IStreamPackable;
import pcl.common.network.StandardModPacket;
import pcl.common.network.TinyModPacket;
import pcl.common.util.WorldLocation;

public abstract class ModPacket {
    protected static final Class<?>[] classReferences = new Class[]{Integer.TYPE, Integer.class, Boolean.TYPE, Boolean.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Character.TYPE, Character.class, String.class, ArrayList.class, HashMap.class};
    protected static ArrayList<IStreamPackable<?>> packableHelpers = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerPackable(IStreamPackable<?> agent) {
        ArrayList<IStreamPackable<?>> arrayList = packableHelpers;
        synchronized (arrayList) {
            packableHelpers.add(agent);
            int id = packableHelpers.indexOf(agent);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IStreamPackable<?> findPacker(int idx) {
        ArrayList<IStreamPackable<?>> arrayList = packableHelpers;
        synchronized (arrayList) {
            for (IStreamPackable<?> packer : packableHelpers) {
                if (packer.getTypeOf() != idx) continue;
                return packer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IStreamPackable<?> findPacker(Class<?> clazz) {
        ArrayList<IStreamPackable<?>> arrayList = packableHelpers;
        synchronized (arrayList) {
            for (IStreamPackable<?> packer : packableHelpers) {
                if (!packer.getClassOf().equals(clazz)) continue;
                return packer;
            }
        }
        return null;
    }

    protected static int getGenericID(Class<?> clazz) {
        for (int i = 0; i < classReferences.length; ++i) {
            if (!classReferences[i].equals(clazz)) continue;
            return i;
        }
        return -1;
    }

    protected static Class<?> getGeneric(int id) {
        if (id >= 0 && id < classReferences.length) {
            return classReferences[id];
        }
        return null;
    }

    public static ModPacket parse(byte[] bytes) throws IOException {
        DataInputStream data = new DataInputStream(new ByteArrayInputStream(bytes));
        byte typeword = data.readByte();
        switch (typeword) {
            case 0: {
                return StandardModPacket.createPacket(data);
            }
            case 1: {
                return TinyModPacket.createPacket(data);
            }
        }
        throw new IOException("Unknown packet typeword!");
    }

    public abstract boolean getPacketIsForServer();

    public abstract Packet250CustomPayload toPacket();

    public abstract String getType();

    public abstract WorldLocation getOriginLocation();
}

