/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.inventory;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class FilterRule {
    private ArrayList<ItemStack> accept = new ArrayList();
    private ArrayList<ItemStack> deny = new ArrayList();
    private boolean whitelist;
    private boolean observeMetadata;

    public FilterRule() {
        new FilterRule(null, null, false, true);
    }

    public FilterRule(ItemStack[] accept, ItemStack[] deny) {
        new FilterRule(accept, deny, false, true);
    }

    public FilterRule(ItemStack[] accept, ItemStack[] deny, boolean whitelist, boolean metadata) {
        if (accept != null) {
            for (ItemStack item : accept) {
                this.accept.add(new ItemStack(item.func_77973_b(), 1));
            }
        }
        if (deny != null) {
            for (ItemStack item : deny) {
                this.deny.add(new ItemStack(item.func_77973_b(), 1));
            }
        }
        this.whitelist = whitelist;
        this.observeMetadata = metadata;
    }

    public void accept(ItemStack item) {
        this.deny.remove(item);
        this.accept.add(item);
    }

    public void deny(ItemStack item) {
        this.accept.remove(item);
        this.deny.add(item);
    }

    public void remove(ItemStack item) {
        this.accept.remove(item);
        this.deny.remove(item);
    }

    public void setMode(boolean whitelist) {
        this.whitelist = whitelist;
    }

    public boolean test(ItemStack testing) {
        if (testing == null || testing.func_77973_b() == null) {
            return true;
        }
        if (this.whitelist) {
            for (ItemStack s : this.accept) {
                if (!this.isItemVirtuallyEqual(s, testing)) continue;
                return true;
            }
            return false;
        }
        for (ItemStack s : this.deny) {
            if (!this.isItemVirtuallyEqual(s, testing)) continue;
            return false;
        }
        return true;
    }

    private boolean isItemVirtuallyEqual(ItemStack a, ItemStack b) {
        if (a.field_77993_c != b.field_77993_c) {
            return false;
        }
        return !this.observeMetadata || a.func_77960_j() == b.func_77960_j();
    }
}

