/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.helpers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;

public class VersionHelper
extends Thread {
    private final String charset = "UTF-8";
    private final int maxTries = 3;
    private final String server = "http://lanteacraft.com/api/" + "build/latest";
    private int tries = 0;
    public String remoteVersion;
    public String remoteLabel;
    public int remoteBuild;
    public boolean finished = false;
    public boolean requiresNotify = false;

    public VersionHelper() {
        this.setDaemon(true);
        this.setName("LanteaCraft version poll thread");
    }

    @Override
    public void run() {
        while (this.tries < 3) {
            try {
                ++this.tries;
                LanteaCraft.getLogger().log(Level.FINE, "Querying version server (try " + this.tries + " of " + 3 + ")");
                this.pullAndParse();
                this.finished = true;
                return;
            }
            catch (IOException ioex) {
                LanteaCraft.getLogger().log(Level.WARNING, "The version metadata pull failed.", ioex);
            }
        }
        LanteaCraft.getLogger().log(Level.WARNING, "Failed to pull version data, maximum tries exceeded!");
    }

    private void pullAndParse() throws IOException {
        String buffer;
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL(this.server).openConnection();
        httpUrlConnection.setConnectTimeout(30000);
        httpUrlConnection.setRequestProperty("Accept-Charset", "UTF-8");
        httpUrlConnection.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
        StringBuilder feed = new StringBuilder();
        while ((buffer = in.readLine()) != null) {
            feed.append(buffer);
        }
        in.close();
        String result = feed.toString();
        try {
            String[] section = result.split(":");
            String[] versionAndBuild = section[0].split("-");
            StringBuilder version = new StringBuilder();
            for (int i = 0; i < versionAndBuild.length; ++i) {
                if (i == versionAndBuild.length - 1) {
                    this.remoteBuild = Integer.parseInt(versionAndBuild[i]);
                    continue;
                }
                version.append(versionAndBuild[i]).append("-");
            }
            String versionStr = version.toString();
            this.remoteVersion = versionStr.substring(0, versionStr.length() - 1);
            this.remoteLabel = section[1].trim();
            if (this.remoteBuild > BuildInfo.getBuildNumber()) {
                this.requiresNotify = true;
            }
        }
        catch (Throwable t) {
            throw new IOException("Strange version sever response: `" + result + "`");
        }
    }
}

