/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.helpers;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import pcl.lc.LanteaCraft;
import pcl.lc.blocks.BlockLanteaDecorStair;
import pcl.lc.fluids.ItemSpecialBucket;

public class RegistrationHelper {
    private static boolean isLateRegistrationZone = false;

    public static void flagLateRegistrationZone() {
        isLateRegistrationZone = true;
    }

    public static <T extends Block> T registerBlock(Class<? extends T> classOf, String unlocalizedName) {
        return RegistrationHelper.registerBlock(classOf, ItemBlock.class, unlocalizedName);
    }

    public static <T extends Block> T registerBlock(Class<? extends T> classOf, Class<? extends ItemBlock> itemClassOf, String unlocalizedName) {
        return RegistrationHelper.registerBlock(classOf, itemClassOf, unlocalizedName, true);
    }

    public static <T extends Block> T registerBlock(Class<? extends T> classOf, Class<? extends ItemBlock> itemClassOf, String unlocalizedName, boolean inCreativeTabs) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("Attempting to register block %s", unlocalizedName));
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this block is later than was expected!");
        }
        try {
            int id = LanteaCraft.getProxy().getConfig().getBlock(unlocalizedName, 2048).getInt();
            Constructor<T> ctor = classOf.getConstructor(Integer.TYPE);
            Block theMysteryBlock = (Block)ctor.newInstance(id);
            theMysteryBlock.func_71864_b(unlocalizedName);
            if (inCreativeTabs) {
                theMysteryBlock.func_71849_a(LanteaCraft.getCreativeTab());
            }
            GameRegistry.registerBlock((Block)theMysteryBlock, itemClassOf, (String)unlocalizedName);
            return (T)theMysteryBlock;
        }
        catch (Throwable e) {
            LanteaCraft.getLogger().log(Level.SEVERE, "Failed to register block, an exception occured.", e);
            throw new RuntimeException(e);
        }
    }

    public static <T extends Item> T registerItem(Class<? extends T> classOf, String unlocalizedName) {
        LanteaCraft.getLogger().log(Level.FINE, "Attempting to register item " + unlocalizedName);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this item is later than was expected!");
        }
        try {
            int id = LanteaCraft.getProxy().getConfig().getItem(unlocalizedName, 4000).getInt();
            Constructor<T> ctor = classOf.getConstructor(Integer.TYPE);
            Item theMysteryItem = (Item)ctor.newInstance(id);
            theMysteryItem.func_77655_b(unlocalizedName).func_77637_a(LanteaCraft.getCreativeTab());
            GameRegistry.registerItem((Item)theMysteryItem, (String)unlocalizedName);
            return (T)theMysteryItem;
        }
        catch (Exception e) {
            LanteaCraft.getLogger().log(Level.SEVERE, "Failed to register item, an exception occured.", e);
            throw new RuntimeException(e);
        }
    }

    public static ItemSpecialBucket registerSpecialBucket(Block hostOf, String unlocalizedName, String bucketTextureName) {
        LanteaCraft.getLogger().log(Level.FINE, "Attempting to register SpecialBucket " + unlocalizedName);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this SpecialBucket is later than was expected!");
        }
        int id = LanteaCraft.getProxy().getConfig().getItem(unlocalizedName, 31743).getInt();
        ItemSpecialBucket bucket = new ItemSpecialBucket(id, hostOf);
        bucket.func_77655_b(unlocalizedName);
        bucket.func_77637_a(LanteaCraft.getCreativeTab());
        bucket.setTargetTexture(bucketTextureName);
        GameRegistry.registerItem((Item)bucket, (String)unlocalizedName);
        return bucket;
    }

    public static void addTradeHandler(int villagerID, VillagerRegistry.IVillageTradeHandler handler) {
        LanteaCraft.getLogger().log(Level.FINE, "Registering trade handler for villager ID " + villagerID);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this trade handler is later than was expected!");
        }
        VillagerRegistry.instance().registerVillageTradeHandler(villagerID, handler);
    }

    public static void registerOre(String name, ItemStack item) {
        LanteaCraft.getLogger().log(Level.FINE, "Registering ore with name " + name);
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this ore is later than was expected!");
        }
        OreDictionary.registerOre((String)String.format("%s:%s", "LanteaCraft", name), (ItemStack)item);
    }

    public static void newRecipe(ItemStack product, Object ... params) {
        LanteaCraft.getLogger().log(Level.FINE, "Registering new generic recipe");
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this recipe is later than was expected!");
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(product, params));
    }

    public static void newShapelessRecipe(ItemStack product, Object ... params) {
        LanteaCraft.getLogger().log(Level.FINE, "Registering new generic shapeless recipe");
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this shapeless recipe is later than was expected!");
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(product, params));
    }

    public static void newSmeltingRecipe(ItemStack product, int input, int meta, float xp) {
        LanteaCraft.getLogger().log(Level.FINE, "Registering new smelting recipe");
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this smelting is later than was expected!");
        }
        FurnaceRecipes.func_77602_a().addSmelting(input, meta, product, xp);
    }

    public static void addRandomChestItem(ItemStack stack, int minQty, int maxQty, int weight, String ... category) {
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this random chest behaviour is later than was expected!");
        }
        WeightedRandomChestContent item = new WeightedRandomChestContent(stack, minQty, maxQty, weight);
        for (String element : category) {
            LanteaCraft.getLogger().log(Level.FINE, "Adding new WeightedRandomChestContent for element " + element);
            ChestGenHooks.addItem((String)element, (WeightedRandomChestContent)item);
        }
    }

    @Deprecated
    public static BlockLanteaDecorStair registerStairDecal(String unlocalizedName, int targetMetadata) {
        LanteaCraft.getLogger().log(Level.INFO, String.format("Attempting to register stair decal %s", unlocalizedName));
        if (isLateRegistrationZone) {
            LanteaCraft.getLogger().log(Level.WARNING, "Warning, registration of this stair decal is later than was expected!");
        }
        try {
            int id = LanteaCraft.getProxy().getConfig().getBlock(unlocalizedName, 2048).getInt();
            BlockLanteaDecorStair stair = new BlockLanteaDecorStair(id, targetMetadata);
            stair.func_71864_b(unlocalizedName);
            stair.func_71849_a(LanteaCraft.getCreativeTab());
            GameRegistry.registerBlock((Block)stair, (String)unlocalizedName);
            return stair;
        }
        catch (Exception e) {
            LanteaCraft.getLogger().log(Level.SEVERE, "Failed to register stair decal, an exception occured.", e);
            throw new RuntimeException(e);
        }
    }
}

