/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.helpers;

import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import net.minecraftforge.common.ForgeVersion;
import pcl.lc.LanteaCraft;

public class AnalyticsHelper
extends Thread {
    private final String charset = "UTF-8";
    private final String server = "http://www.pc-logix.com/SGCraft_analytics/";
    private final StringBuilder report;
    private final int maxTries = 3;
    private int tries = 0;
    private boolean overrideValidity = false;

    public AnalyticsHelper(boolean submitAnyway, String[] reportData) {
        this.setDaemon(true);
        this.setName("LanteaCraft analytics submission thread");
        this.report = new StringBuilder();
        this.overrideValidity = submitAnyway;
        try {
            if (reportData != null) {
                this.report.append(this.pack("version", reportData[0]));
                this.report.append(this.pack("side", reportData[1]));
                this.report.append(this.pack("forge", reportData[2]));
            } else {
                StringBuilder buildName = new StringBuilder();
                buildName.append("LanteaCraft").append(" ");
                buildName.append("RC1").append(" ");
                buildName.append("build ").append("37");
                this.report.append(this.pack("version", buildName.toString()));
                this.report.append(this.pack("side", FMLLaunchHandler.side().name()));
                this.report.append(this.pack("forge", ForgeVersion.getVersion()));
            }
        }
        catch (UnsupportedEncodingException e) {
            LanteaCraft.getLogger().log(Level.WARNING, "This client is weird and doesn't suppport UTF-8, giving up.");
            this.tries += 3;
        }
    }

    @Override
    public void run() {
        if ("37".equals("@BUILD@") && !this.overrideValidity) {
            return;
        }
        while (this.tries < 3) {
            try {
                ++this.tries;
                LanteaCraft.getLogger().log(Level.FINE, "Pushing metrics data (try " + this.tries + " of " + 3 + ")");
                this.push();
                LanteaCraft.getLogger().log(Level.FINE, "Done submitting anonymous data.");
                return;
            }
            catch (IOException ioex) {
                LanteaCraft.getLogger().log(Level.WARNING, "The metrics push failed.", ioex);
            }
        }
        LanteaCraft.getLogger().log(Level.WARNING, "Failed to push metrics data, maximum tries exceeded!");
    }

    public String getReportData() {
        return this.report.toString();
    }

    private String pack(String arg, String val) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        result.append(arg).append("=");
        result.append(URLEncoder.encode(val, "UTF-8")).append("&");
        return result.toString();
    }

    private void push() throws IOException {
        HttpURLConnection httpUrlConnection = (HttpURLConnection)new URL("http://www.pc-logix.com/SGCraft_analytics/").openConnection();
        httpUrlConnection.setDoOutput(true);
        httpUrlConnection.setConnectTimeout(30000);
        httpUrlConnection.setRequestProperty("Accept-Charset", "UTF-8");
        httpUrlConnection.setRequestMethod("POST");
        OutputStream os = httpUrlConnection.getOutputStream();
        os.write(this.report.toString().getBytes("UTF-8"));
        os.flush();
        os.close();
        BufferedReader in = new BufferedReader(new InputStreamReader(httpUrlConnection.getInputStream()));
        String s = null;
        StringBuilder resp = new StringBuilder();
        while ((s = in.readLine()) != null) {
            resp.append(s);
            if (!s.trim().equals("OK")) continue;
            in.close();
            return;
        }
        in.close();
        throw new IOException("Unexpected metrics server response: " + resp.toString());
    }
}

