/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.base;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraftforge.common.ForgeChunkManager;
import pcl.common.base.GenericTileEntity;
import pcl.common.base.TileEntityChunkManager;

public abstract class TileEntityChunkLoader
extends GenericTileEntity {
    ForgeChunkManager.Ticket chunkTicket;

    public abstract TileEntityChunkManager getChunkManager();

    public void setForcedChunkRange(int minX, int minZ, int maxX, int maxZ) {
        this.releaseChunkTicket();
        ForgeChunkManager.Ticket ticket = this.getChunkTicket();
        if (ticket != null) {
            NBTTagCompound nbt = ticket.getModData();
            nbt.func_74778_a("type", "TileEntity");
            nbt.func_74768_a("xCoord", this.field_70329_l);
            nbt.func_74768_a("yCoord", this.field_70330_m);
            nbt.func_74768_a("zCoord", this.field_70327_n);
            nbt.func_74768_a("rangeMinX", minX);
            nbt.func_74768_a("rangeMinZ", minZ);
            nbt.func_74768_a("rangeMaxX", maxX);
            nbt.func_74768_a("rangeMaxZ", maxZ);
            this.forceChunkRangeOnTicket(ticket);
        }
    }

    public void clearForcedChunkRange() {
        this.releaseChunkTicket();
    }

    public void forceChunkRangeOnTicket(ForgeChunkManager.Ticket ticket) {
        NBTTagCompound nbt = ticket.getModData();
        int minX = nbt.func_74762_e("rangeMinX");
        int minZ = nbt.func_74762_e("rangeMinZ");
        int maxX = nbt.func_74762_e("rangeMaxX");
        int maxZ = nbt.func_74762_e("rangeMaxZ");
        int chunkX = this.field_70329_l >> 4;
        int chunkZ = this.field_70327_n >> 4;
        for (int i = minX; i <= maxX; ++i) {
            for (int j = minZ; j <= maxZ; ++j) {
                int x = chunkX + i;
                int z = chunkZ + j;
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(x, z));
            }
        }
    }

    public ForgeChunkManager.Ticket getChunkTicket() {
        if (this.chunkTicket == null) {
            this.chunkTicket = this.getChunkManager().newTicket(this.field_70331_k);
        }
        return this.chunkTicket;
    }

    public boolean reinstateChunkTicket(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
            this.forceChunkRangeOnTicket(ticket);
            return true;
        }
        return false;
    }

    public void func_70313_j() {
        this.releaseChunkTicket();
        super.func_70313_j();
    }

    public void releaseChunkTicket() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            this.chunkTicket = null;
        }
    }
}

