/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.base;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.Loader;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import pcl.common.asm.RuntimeAnnotation;
import pcl.common.base.GenericTileEntity;
import pcl.lc.api.EnumUnits;
import universalelectricity.core.electricity.ElectricityPack;

public abstract class PoweredTileEntity
extends GenericTileEntity {
    Object receiverBuffer;

    public PoweredTileEntity() {
        if (Loader.isModLoaded((String)"BuildCraft|Core")) {
            float maxRecieveQuantity;
            PowerHandler b = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
            b.configure(0.0f, maxRecieveQuantity, (maxRecieveQuantity = (float)EnumUnits.convertFromNaquadahUnit(EnumUnits.MinecraftJoules, this.getMaximumReceiveEnergy())) == 0.0f ? 99999.0f : 1.0f, maxRecieveQuantity == 0.0f ? 0.0f : 1000.0f);
            b.configurePowerPerdition(0, 0);
            this.receiverBuffer = b;
        }
    }

    public abstract boolean canReceiveEnergy();

    public abstract boolean canExportEnergy();

    public abstract double getMaximumReceiveEnergy();

    public abstract double getMaximumExportEnergy();

    public abstract double getAvailableExportEnergy();

    public abstract void receiveEnergy(double var1);

    public abstract double exportEnergy(double var1);

    public abstract boolean canEnergyFormatConnectToSide(EnumUnits var1, ForgeDirection var2);

    public void func_70316_g() {
        super.func_70316_g();
        if (this.canExportEnergy() && !this.field_70331_k.field_72995_K && this.receiverBuffer != null) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                this.emitEnergy(direction);
            }
        }
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergyEmitter")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.canEnergyFormatConnectToSide(EnumUnits.EnergyUnit, direction) && this.canExportEnergy();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerEmitter")
    public boolean canEmitPowerFrom(ForgeDirection side) {
        return this.canEnergyFormatConnectToSide(EnumUnits.MinecraftJoules, side) && this.canExportEnergy();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerReceptor")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return ((PowerHandler)this.receiverBuffer).getPowerReceiver();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerReceptor")
    public void doWork(PowerHandler workProvider) {
        float quantity = workProvider.useEnergy(0.0f, 100.0f, true);
        double naqQuantity = EnumUnits.convertToNaquadahUnit(EnumUnits.MinecraftJoules, quantity);
        this.receiveEnergy(naqQuantity);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="BuildCraft|Core", clazz="buildcraft.api.power.IPowerReceptor")
    public World getWorld() {
        return this.field_70331_k;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergyAcceptor")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.canEnergyFormatConnectToSide(EnumUnits.EnergyUnit, direction) && this.canReceiveEnergy();
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySource")
    public double getOfferedEnergy() {
        double naqAvailable = this.getAvailableExportEnergy();
        return EnumUnits.convertFromNaquadahUnit(EnumUnits.EnergyUnit, naqAvailable);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySource")
    public void drawEnergy(double amount) {
        double naqQuantity = EnumUnits.convertToNaquadahUnit(EnumUnits.EnergyUnit, amount);
        this.exportEnergy(naqQuantity);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySink")
    public double demandedEnergyUnits() {
        if (!this.canReceiveEnergy()) {
            return 0.0;
        }
        return EnumUnits.convertFromNaquadahUnit(EnumUnits.EnergyUnit, this.getMaximumReceiveEnergy());
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySink")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (!this.canReceiveEnergy()) {
            return 0.0;
        }
        double quantity = EnumUnits.convertToNaquadahUnit(EnumUnits.EnergyUnit, amount);
        this.receiveEnergy(quantity);
        return amount;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="IC2", clazz="ic2.api.energy.tile.IEnergySink")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    private void emitEnergy(ForgeDirection direction) {
        int x = direction.offsetX + this.field_70329_l;
        int y = direction.offsetY + this.field_70330_m;
        int z = direction.offsetZ + this.field_70327_n;
        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
        if (tile != null && tile instanceof IPowerReceptor && ((IPowerReceptor)tile).getPowerReceiver(direction.getOpposite()) != null) {
            PowerHandler.PowerReceiver receptor = ((IPowerReceptor)tile).getPowerReceiver(direction.getOpposite());
            float maxQuantity = receptor.getMaxEnergyReceived();
            float maxAvailQuantity = (float)EnumUnits.convertFromNaquadahUnit(EnumUnits.MinecraftJoules, this.getAvailableExportEnergy());
            float send = Math.min(maxQuantity, maxAvailQuantity);
            float quantityUsed = receptor.receiveEnergy(PowerHandler.Type.MACHINE, send, direction.getOpposite());
            this.exportEnergy(EnumUnits.convertToNaquadahUnit(EnumUnits.MinecraftJoules, quantityUsed));
        }
    }

    @RuntimeAnnotation.RuntimeInterface(modid="UniversalElectricity", clazz="universalelectricity.core.block.IConnector")
    public boolean canConnect(ForgeDirection direction) {
        return this.canEnergyFormatConnectToSide(EnumUnits.UniversalAmperes, direction);
    }

    @RuntimeAnnotation.RuntimeInterface(modid="UniversalElectricity", clazz="universalelectricity.core.block.IElectrical")
    public float receiveElectricity(ForgeDirection from, ElectricityPack receive, boolean doReceive) {
        return 0.0f;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="UniversalElectricity", clazz="universalelectricity.core.block.IElectrical")
    public ElectricityPack provideElectricity(ForgeDirection from, ElectricityPack request, boolean doProvide) {
        return null;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="UniversalElectricity", clazz="universalelectricity.core.block.IElectrical")
    public float getRequest(ForgeDirection direction) {
        return (float)EnumUnits.convertFromNaquadahUnit(EnumUnits.UniversalAmperes, this.getMaximumReceiveEnergy());
    }

    @RuntimeAnnotation.RuntimeInterface(modid="UniversalElectricity", clazz="universalelectricity.core.block.IElectrical")
    public float getProvide(ForgeDirection direction) {
        return (float)EnumUnits.convertFromNaquadahUnit(EnumUnits.UniversalAmperes, this.getMaximumExportEnergy());
    }

    @RuntimeAnnotation.RuntimeInterface(modid="UniversalElectricity", clazz="universalelectricity.core.block.IElectrical")
    public float getVoltage() {
        return 240.0f;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.canReceiveEnergy()) {
            return 0;
        }
        int quantity = (int)Math.floor(EnumUnits.convertToNaquadahUnit(EnumUnits.RedstoneFlux, maxReceive));
        if (!simulate) {
            this.receiveEnergy(quantity);
        }
        return quantity;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.canExportEnergy()) {
            return 0;
        }
        int maxAvailQuantity = (int)EnumUnits.convertFromNaquadahUnit(EnumUnits.RedstoneFlux, this.getAvailableExportEnergy());
        int send = Math.min(maxExtract, maxAvailQuantity);
        if (!simulate) {
            this.exportEnergy(send);
        }
        return send;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int getEnergyStored(ForgeDirection from) {
        return (int)EnumUnits.convertFromNaquadahUnit(EnumUnits.RedstoneFlux, this.getAvailableExportEnergy());
    }

    @RuntimeAnnotation.RuntimeInterface(modid="CoFHCore", clazz="cofh.api.energy.IEnergyHandler")
    public int getMaxEnergyStored(ForgeDirection from) {
        return (int)EnumUnits.convertFromNaquadahUnit(EnumUnits.RedstoneFlux, this.getMaximumExportEnergy());
    }
}

