/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.base;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import pcl.common.base.GenericContainer;
import pcl.lc.LanteaCraft;
import pcl.lc.guis.GlyphRenderer;

public abstract class GenericContainerGUI
extends GuiContainer {
    static final int defaultTextColor = 0x404040;
    double uscale;
    double vscale;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    protected int textColor = 0x404040;
    boolean textShadow = false;

    public GenericContainerGUI(Container container, int width, int height) {
        super(container);
        this.field_74194_b = width;
        this.field_74195_c = height;
    }

    public GenericContainerGUI(GenericContainer container) {
        this(container, container.xSize, container.ySize);
    }

    protected abstract void drawBackgroundLayer(float var1, int var2, int var3);

    protected abstract void drawForegroundLayer(int var1, int var2);

    public void func_73863_a(int par1, int par2, float par3) {
        this.resetColor();
        this.textColor = 0x404040;
        this.textShadow = false;
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_74185_a(float partialTickCount, int mouseX, int mouseY) {
        this.drawBackgroundLayer(partialTickCount, mouseX, mouseY);
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        this.drawForegroundLayer(mouseX, mouseY);
    }

    protected void close() {
        this.field_73882_e.field_71439_g.func_71053_j();
    }

    public void drawFramedSymbols(int x, int y, String address) {
        int scale = 2;
        this.bindTexture(LanteaCraft.getResource("textures/gui/symbol_frame.png"), 512 / scale, 128 / scale);
        this.drawTexturedRect(x - 472 / scale / 2, y, 472 / scale, 88 / scale, 0.0, 0.0);
        GlyphRenderer.drawAddress(this.field_73882_e, address, x - 472 / scale / 2, y, 9, scale, this.field_73735_i);
    }

    public void drawAddressString(int x, int y, String address, int len, String padding, String caret) {
        StringBuilder result = new StringBuilder();
        result.append(address);
        if (len != result.length() && caret != null) {
            result.append(caret);
        }
        while (len > result.length()) {
            result.append(padding);
        }
        this.func_73732_a(this.field_73886_k, result.toString(), x, y, 0xFFFFFF);
    }

    protected void bindTexture(ResourceLocation rsrc) {
        this.bindTexture(rsrc, 1, 1);
    }

    public void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        this.field_73882_e.func_110434_K().func_110577_a(rsrc);
        this.uscale = 1.0 / (double)usize;
        this.vscale = 1.0 / (double)vsize;
    }

    public void drawTexturedRect(double x, double y, double w, double h) {
        this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.uscale, v * this.vscale, us * this.uscale, vs * this.vscale);
    }

    public void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(this.red, this.green, this.blue);
        tess.func_78374_a(x, y + h, (double)this.field_73735_i, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)this.field_73735_i, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)this.field_73735_i, u + us, v);
        tess.func_78374_a(x, y, (double)this.field_73735_i, u, v);
        tess.func_78381_a();
    }

    public void setColor(int hex) {
        this.setColor((double)(hex >> 16) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public void setColor(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }

    public void drawString(String s, int x, int y) {
        this.field_73886_k.func_85187_a(s, x, y, this.textColor, this.textShadow);
    }

    public void drawCenteredString(String s, int x, int y) {
        this.field_73886_k.func_85187_a(s, x - this.field_73886_k.func_78256_a(s) / 2, y, this.textColor, this.textShadow);
    }

    public void drawInventoryName(IInventory inv, int x, int y) {
        this.drawString(GenericContainerGUI.inventoryName(inv), x, y);
    }

    public void drawPlayerInventoryName() {
        this.drawString(GenericContainerGUI.playerInventoryName(), 8, this.field_74195_c - 96 + 2);
    }

    public static String inventoryName(IInventory inv) {
        String name = inv.func_70303_b();
        if (!inv.func_94042_c()) {
            name = StatCollector.func_74838_a((String)name);
        }
        return name;
    }

    public static String playerInventoryName() {
        return StatCollector.func_74838_a((String)"container.inventory");
    }
}

