/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.audio;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import paulscode.sound.SoundSystem;
import pcl.common.audio.AudioPosition;
import pcl.common.audio.AudioSource;
import pcl.common.audio.ClientAudioEngine;
import pcl.common.audio.ClientSoundProtocolHandler;
import pcl.common.util.Vector3;
import pcl.lc.BuildInfo;
import pcl.lc.LanteaCraft;

public class ClientAudioSource
extends AudioSource
implements Comparable<ClientAudioSource> {
    private SoundSystem system;
    private AudioPosition position;
    private String name;
    private boolean valid;
    private boolean culled;
    private float configuredVolume;
    private float realVolume;

    public ClientAudioSource(SoundSystem system, AudioPosition position, String file, boolean looping, boolean override, float volume, String tag) {
        try {
            this.system = system;
            this.position = position;
            this.name = tag;
            this.configuredVolume = volume;
            ClientAudioEngine engine = (ClientAudioEngine)LanteaCraft.getProxy().getAudioEngine();
            String filename = LanteaCraft.getAssetKey() + ":sound/" + file;
            ResourceLocation resourcelocation = new ResourceLocation(filename);
            String s1 = String.format("%s:%s:%s", "soundconnectionhax", resourcelocation.func_110624_b(), resourcelocation.func_110623_a());
            if (BuildInfo.SS_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, "AudioSource mounting file: " + s1);
            }
            URL path = new URL(null, s1, new ClientSoundProtocolHandler());
            system.newSource(override, this.name, path, file, looping, (float)position.position.x, (float)position.position.y, (float)position.position.z, 0, engine.falloffDistance * Math.max(volume, 1.0f));
            this.valid = true;
            this.setVolume(volume);
        }
        catch (MalformedURLException malurl) {
            LanteaCraft.getLogger().log(Level.WARNING, "Could not initialize AudioSource.", malurl);
        }
    }

    @Override
    public void play() {
        if (!this.valid) {
            return;
        }
        if (this.isPlaying()) {
            if (BuildInfo.SS_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Can't play sound %s because it's already playing.", this.name));
            }
            return;
        }
        if (this.culled) {
            if (BuildInfo.SS_DEBUGGING) {
                LanteaCraft.getLogger().log(Level.INFO, String.format("Can't play sound %s because it's culled.", this.name));
            }
            return;
        }
        if (this.name == null) {
            LanteaCraft.getLogger().log(Level.WARNING, "Attempt to perform audio operation on illegal label.");
        }
        this.system.play(this.name);
    }

    @Override
    public void pause() {
        if (!this.valid || !this.isPlaying() || this.culled) {
            return;
        }
        this.system.pause(this.name);
    }

    @Override
    public void stop() {
        if (!this.valid || !this.isPlaying()) {
            return;
        }
        if (this.culled) {
            return;
        }
        this.system.stop(this.name);
        this.system.rewind(this.name);
    }

    @Override
    public void remove() {
        if (!this.valid) {
            return;
        }
        if (this.name == null) {
            return;
        }
        this.stop();
        this.system.removeSource(this.name);
        this.name = null;
        this.valid = false;
    }

    @Override
    public void flush() {
        if (!this.valid || !this.isPlaying() || this.culled) {
            return;
        }
        this.system.flush(this.name);
    }

    @Override
    public float getVolume() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.system.getVolume(this.name);
    }

    @Override
    public void setVolume(float f) {
        this.configuredVolume = f;
        this.system.setVolume(this.name, 0.001f);
    }

    @Override
    public float getPitch() {
        if (!this.valid) {
            return 0.0f;
        }
        return this.system.getPitch(this.name);
    }

    @Override
    public void setPitch(float f) {
        if (!this.valid) {
            return;
        }
        this.system.setPitch(this.name, f);
    }

    @Override
    public void advance(EntityPlayer clientPlayer) {
        if (!this.valid || !this.isPlaying()) {
            this.realVolume = 0.0f;
            return;
        }
        float md = ((ClientAudioEngine)LanteaCraft.getProxy().getAudioEngine()).falloffDistance;
        md *= Math.max(this.configuredVolume, 1.0f);
        float rolloff = 1.0f;
        float rd = 1.0f;
        float d = 0.0f;
        if (this.position.world.equals(clientPlayer.field_70170_p)) {
            d = (float)this.position.position.sub(new Vector3((Entity)clientPlayer)).mag();
        }
        if (d > md) {
            this.realVolume = 0.0f;
            this.cull();
            return;
        }
        if (rd > d) {
            d = rd;
        }
        float gain = 1.0f - rolloff * (d - rd) / (md - rd);
        float nrv = gain * this.configuredVolume * ((ClientAudioEngine)LanteaCraft.getProxy().getAudioEngine()).masterVolume;
        Vector3 i = new Vector3((Entity)clientPlayer);
        Vector3 j = this.position.position.sub(i).div(d);
        if (nrv > 0.1f) {
            int k = 0;
            while ((float)k < d) {
                int b = clientPlayer.field_70170_p.func_72798_a((int)i.x, (int)i.y, (int)i.z);
                if (b != 0) {
                    nrv = Block.field_71970_n[b] ? (nrv *= 0.5f) : (nrv *= 0.85f);
                }
                i.add(j);
                ++k;
            }
        }
        if ((double)Math.abs(this.realVolume / nrv - 1.0f) > 0.06) {
            this.system.setVolume(this.name, Math.min(nrv, 1.0f) * ((ClientAudioEngine)LanteaCraft.getProxy().getAudioEngine()).masterVolume);
        }
        this.realVolume = nrv;
    }

    @Override
    public void activate() {
        if (!this.valid || !this.culled) {
            return;
        }
        this.system.activate(this.name);
        this.culled = false;
        if (this.isPlaying()) {
            this.stop();
            this.play();
        }
    }

    @Override
    public void cull() {
        if (!this.valid || this.culled) {
            return;
        }
        this.system.cull(this.name);
        this.culled = true;
    }

    @Override
    public float getRealVolume() {
        return this.realVolume;
    }

    @Override
    public int compareTo(ClientAudioSource x) {
        if (this.culled) {
            return (int)((this.realVolume * 0.9f - x.realVolume) * 128.0f);
        }
        return (int)((this.realVolume - x.realVolume) * 128.0f);
    }

    @Override
    public boolean isPlaying() {
        if (!this.valid || this.name == null) {
            return false;
        }
        return this.system.playing(this.name);
    }
}

