/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.audio;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import pcl.common.audio.AudioEngine;
import pcl.common.audio.AudioPosition;
import pcl.common.audio.AudioSource;
import pcl.common.audio.ClientAudioSource;
import pcl.lc.api.internal.ITickAgent;

public class ClientAudioEngine
extends AudioEngine
implements ITickAgent {
    private static int sourceCounter = 0;
    public final float falloffDistance = 22.0f;
    private final int maxStreamingSources = 8;
    public boolean enabled = true;
    public int maxSources = 32;
    public float masterVolume = 0.5f;
    private SoundSystem system = null;
    private HashMap<SoundHostObject, ArrayList<AudioSource>> hostSourceList = new HashMap();

    private static String label() {
        StringBuilder label = new StringBuilder();
        label.append("lc_directsound_").append(sourceCounter);
        if (++sourceCounter > 512) {
            sourceCounter %= 512;
        }
        return label.toString();
    }

    @Override
    public void initialize() {
        SoundSystemConfig.setNumberStreamingChannels((int)8);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSources - 8));
    }

    @Override
    public AudioSource create(Object owner, AudioPosition position, String file, boolean looping, boolean override, float volume) {
        String tag = ClientAudioEngine.label();
        ClientAudioSource source = new ClientAudioSource(this.system, position, file, looping, override, volume, tag);
        SoundHostObject host = new SoundHostObject(owner);
        if (!this.hostSourceList.containsKey(host)) {
            this.hostSourceList.put(host, new ArrayList());
        }
        this.hostSourceList.get(host).add(source);
        return source;
    }

    @Override
    public void advance() {
        if (!this.enabled) {
            return;
        }
        if (this.system == null) {
            this.system = Minecraft.func_71410_x().field_71416_A.field_77381_a;
        }
        if (this.system == null) {
            return;
        }
        float vol = Minecraft.func_71410_x().field_71474_y.field_74340_b;
        if (this.masterVolume != vol) {
            this.masterVolume = vol;
        }
        Vector<SoundHostObject> stopSounds = new Vector<SoundHostObject>();
        EntityClientPlayerMP client = Minecraft.func_71410_x().field_71439_g;
        if (client == null) {
            stopSounds.addAll(this.hostSourceList.keySet());
        } else {
            PriorityQueue<AudioSource> soundQueue = new PriorityQueue<AudioSource>();
            for (Map.Entry<SoundHostObject, ArrayList<AudioSource>> entry : this.hostSourceList.entrySet()) {
                if (entry.getKey().isEnqueued()) {
                    stopSounds.add(entry.getKey());
                    continue;
                }
                for (AudioSource audioSource : entry.getValue()) {
                    audioSource.advance((EntityPlayer)client);
                    if (!(audioSource.getRealVolume() > 0.0f)) continue;
                    soundQueue.add(audioSource);
                }
            }
            int k = 0;
            while (!soundQueue.isEmpty()) {
                AudioSource source = (AudioSource)soundQueue.poll();
                if (this.maxSources > k) {
                    source.activate();
                } else {
                    source.cull();
                }
                ++k;
            }
        }
        for (SoundHostObject host : stopSounds) {
            this.removeSources(host);
        }
    }

    private void removeSources(Object o) {
        if (this.system == null) {
            return;
        }
        SoundHostObject host = !(o instanceof SoundHostObject) ? new SoundHostObject(o) : (SoundHostObject)o;
        if (!this.hostSourceList.containsKey(host)) {
            return;
        }
        ArrayList<AudioSource> sources = this.hostSourceList.get(host);
        for (AudioSource source : sources) {
            source.remove();
        }
        this.hostSourceList.remove(host);
    }

    private static class SoundHostObject
    extends WeakReference<Object> {
        public SoundHostObject(Object host) {
            super(host);
        }

        public int hashCode() {
            if (this.get() != null) {
                return this.get().hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoundHostObject)) {
                return this.get().equals(o);
            }
            return this.get().equals(((SoundHostObject)o).get());
        }
    }
}

