/*
 * Decompiled with CFR 0.152.
 */
package pcl.common.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.launchwrapper.IClassTransformer;
import pcl.common.asm.PCLCoreTransformerPlugin;

public class PCLCoreTransformer
implements IClassTransformer {
    private final List<IClassTransformer> transformers;
    public static boolean ASM_SUCCESS = false;

    public PCLCoreTransformer() {
        ASM_SUCCESS = true;
        String[] tnames = PCLCoreTransformerPlugin.getTransformers();
        this.transformers = new ArrayList<IClassTransformer>(tnames.length);
        for (String transformer : tnames) {
            try {
                this.transformers.add((IClassTransformer)Class.forName(transformer).newInstance());
                PCLCoreTransformerPlugin.getLogger().log(Level.FINE, "Instantiated transformer " + transformer);
            }
            catch (Throwable e) {
                PCLCoreTransformerPlugin.getLogger().log(Level.WARNING, "Could not instantiate transformer " + transformer);
                e.printStackTrace();
            }
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        for (IClassTransformer transformer : this.transformers) {
            try {
                if ((bytes = transformer.transform(name, transformedName, bytes)) != null) continue;
                PCLCoreTransformerPlugin.getLogger().log(Level.SEVERE, "Transformer " + transformer + " corrupted class " + name);
            }
            catch (Throwable e) {
                PCLCoreTransformerPlugin.getLogger().log(Level.WARNING, "Could not transform class " + name + " using " + transformer);
                e.printStackTrace();
            }
        }
        return bytes;
    }
}

