/*
 * Decompiled with CFR 0.152.
 */
package net.afterlifelochie.sandbox;

import net.afterlifelochie.sandbox.Observable;
import net.afterlifelochie.sandbox.ObserverContext;

public class WatchedValue<T>
extends Observable {
    private volatile T value;
    private volatile int last;

    public WatchedValue(T initial) {
        super(null);
        this.value = initial;
    }

    public WatchedValue(Observable parent, T initial) {
        super(parent);
        this.value = initial;
    }

    @Override
    public boolean modified(ObserverContext context) {
        if (!context.states.containsKey(this.hashCode())) {
            return true;
        }
        return context.states.get(this.hashCode()).intValue() != this.value.hashCode();
    }

    @Override
    public void clearModified(ObserverContext context) {
        context.states.put(this.hashCode(), this.value.hashCode());
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.last = this.value.hashCode();
        this.value = value;
        this.modify();
    }

    public void reset() {
        this.last = this.value.hashCode();
        this.value = null;
        this.modify();
    }

    public int last() {
        return this.last;
    }

    public boolean equals(Object o) {
        if (o instanceof WatchedValue) {
            return this.get().equals(((WatchedValue)o).get());
        }
        return this.get().equals(o);
    }

    public String toString() {
        return "WatchedValue: { " + (this.get() != null ? this.get().toString() : "null") + " }";
    }
}

