/*
 * Decompiled with CFR 0.152.
 */
package net.afterlifelochie.sandbox;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.afterlifelochie.sandbox.Observable;
import net.afterlifelochie.sandbox.ObserverContext;

public class WatchedList<A, B>
extends Observable {
    private HashMap<A, B> values = new HashMap();
    private ArrayList<A> key_add = new ArrayList();
    private ArrayList<A> key_remove = new ArrayList();

    public WatchedList() {
        super(null);
    }

    public WatchedList(Observable parent) {
        super(parent);
    }

    @Override
    public void clearModified(ObserverContext context) {
        super.clearModified(context);
        this.key_add.clear();
        this.key_remove.clear();
    }

    public B get(A key) {
        return this.values.get(key);
    }

    public Set<Map.Entry<A, B>> entrySet() {
        return this.values.entrySet();
    }

    public Iterator<B> values() {
        return this.values.values().iterator();
    }

    public Iterator<A> keys() {
        return this.values.keySet().iterator();
    }

    public B set(A key, B value) {
        this.modify();
        if (!this.values.containsKey(key) && !this.key_add.contains(key)) {
            this.key_add.add(key);
        }
        return this.values.put(key, value);
    }

    public int size() {
        return this.values.size();
    }

    public B remove(A key) {
        this.modify();
        if (this.values.containsKey(key) && !this.key_remove.contains(key)) {
            this.key_remove.add(key);
        }
        return this.values.remove(key);
    }

    public void clear() {
        this.modify();
        for (A next : this.values.keySet()) {
            if (this.key_remove.contains(next)) continue;
            this.key_remove.add(next);
        }
        this.values.clear();
    }

    public ArrayList<A> added() {
        return this.key_add;
    }

    public ArrayList<A> removed() {
        return this.key_remove;
    }
}

