/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.parts;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.util.IToolPart;

public class Part
extends Item
implements IToolPart {
    protected String defaultIconTexture;
    protected int defaultMaterialID;
    protected String unlocalizedPartName;
    protected HashMap<Integer, String> unlocalizedMaterialNames = new HashMap();
    protected HashMap<Integer, String> textures = new HashMap();
    protected HashMap<Integer, Icon> icons = new HashMap();
    protected static final String pathToTextures = "ExtraTiC".toLowerCase(Locale.ENGLISH) + ":" + "parts/";

    public Part(int id, String defaultUnlocalizedPartName, int defaultMaterialID, String defaultTexture) {
        super(id);
        this.func_77637_a((CreativeTabs)TConstructRegistry.materialTab);
        this.func_77625_d(64);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77655_b("default." + defaultUnlocalizedPartName);
        this.unlocalizedPartName = defaultUnlocalizedPartName;
        this.defaultMaterialID = defaultMaterialID;
        this.defaultIconTexture = pathToTextures + defaultTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister icon) {
        this.field_77791_bV = icon.func_94245_a(this.defaultIconTexture);
        for (Map.Entry<Integer, String> texture : this.textures.entrySet()) {
            int matrialID = texture.getKey();
            String texutreName = texture.getValue();
            Icon _icon = icon.func_94245_a(pathToTextures + texutreName);
            this.icons.put(matrialID, _icon);
        }
    }

    public int getMaterialID(ItemStack itemStack) {
        int damageValue = itemStack.func_77960_j();
        if (damageValue >= 100) {
            return itemStack.func_77960_j();
        }
        return this.defaultMaterialID;
    }

    public void addMaterial(int materialId, String unlocalizedName, String texture) {
        this.unlocalizedMaterialNames.put(materialId, unlocalizedName);
        this.textures.put(materialId, texture);
    }

    public Icon func_77617_a(int damageValue) {
        if (this.icons.containsKey(damageValue)) {
            return this.icons.get(damageValue);
        }
        return this.field_77791_bV;
    }

    public void func_77633_a(int id, CreativeTabs tab, List itemStackList) {
        if (!this.unlocalizedMaterialNames.isEmpty()) {
            for (Map.Entry<Integer, String> subItem : this.unlocalizedMaterialNames.entrySet()) {
                int matrialId = subItem.getKey();
                itemStackList.add(new ItemStack(id, 1, matrialId));
            }
        } else {
            itemStackList.add(new ItemStack((Item)this, 1));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        int damageValue = itemStack.func_77960_j();
        if (this.unlocalizedMaterialNames.containsKey(damageValue)) {
            return "item." + this.unlocalizedMaterialNames.get(damageValue) + "." + this.unlocalizedPartName;
        }
        return this.func_77658_a();
    }

    public String func_77628_j(ItemStack itemStack) {
        String displayName;
        int damageValue = itemStack.func_77960_j();
        if (this.unlocalizedMaterialNames.containsKey(damageValue)) {
            String unlocalizedMaterialName = this.unlocalizedMaterialNames.get(damageValue);
            if (StatCollector.func_94522_b((String)("part." + this.unlocalizedPartName)) && StatCollector.func_94522_b((String)("material." + unlocalizedMaterialName))) {
                String localizedPartName = StatCollector.func_74838_a((String)("part." + this.unlocalizedPartName));
                String localizedMaterialName = StatCollector.func_74838_a((String)("material." + unlocalizedMaterialName));
                displayName = localizedPartName.replaceAll("@material@", localizedMaterialName);
            } else {
                displayName = this.func_77667_c(itemStack) + ".name";
            }
        } else {
            displayName = this.func_77658_a() + ".name";
        }
        return displayName;
    }
}

