/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.extratic.metals;

import com.google.common.collect.HashBiMap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class MoltenMetalBucketItem
extends ItemBucket
implements IFluidContainerItem {
    private Icon _filling = null;
    private int _fluidBlockId = 0;
    private int _capacity = 1000;
    private HashBiMap<Integer, String> fluidNames = HashBiMap.create();
    private HashMap<Integer, String> textures = new HashMap();
    private HashMap<Integer, Icon> icons = new HashMap();
    protected static final String pathToTextures = "ExtraTiC".toLowerCase(Locale.ENGLISH) + ":" + "bucket/";

    public MoltenMetalBucketItem(int itemId, int fluidBlockId) {
        super(itemId, fluidBlockId);
        this._fluidBlockId = fluidBlockId;
        this.func_77655_b("extratic.bucket");
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77642_a(Item.field_77788_aw);
        this.func_111206_d("minecraft:bucket_empty");
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int damage) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.func_111208_A());
        this._filling = register.func_94245_a(pathToTextures + "bucket_fill_adamantine");
        for (Map.Entry<Integer, String> entry : this.textures.entrySet()) {
            Icon filling = register.func_94245_a(pathToTextures + entry.getValue());
            this.icons.put(entry.getKey(), filling);
        }
    }

    public Icon getIcon(ItemStack itemStack, int pass) {
        if (pass == 0 || itemStack.field_77990_d == null) {
            return this.field_77791_bV;
        }
        FluidStack fluidStack = this.getFluid(itemStack);
        if (fluidStack == null) {
            return this.field_77791_bV;
        }
        String fluidname = fluidStack.getFluid().getName();
        if (this.fluidNames.containsValue((Object)fluidname)) {
            int index = (Integer)this.fluidNames.inverse().get((Object)fluidname);
            this._filling = this.icons.get(index);
            if (this._filling != null) {
                return this._filling;
            }
            return this.field_77791_bV;
        }
        return this.field_77791_bV;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (itemStack == null) {
            return itemStack;
        }
        FluidStack fluidStack = this.getFluid(itemStack);
        if (fluidStack == null) {
            return itemStack;
        }
        this._fluidBlockId = fluidStack.getFluid().getBlockID();
        boolean isAir = this._fluidBlockId == 0;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, isAir);
        if (movingobjectposition == null) {
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == EnumMovingObjectType.TILE) {
            int xCoord = movingobjectposition.field_72311_b;
            int yCoord = movingobjectposition.field_72312_c;
            int zCoord = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, xCoord, yCoord, zCoord)) {
                return itemStack;
            }
            if (this._fluidBlockId <= 0) {
                return new ItemStack(this.func_77668_q());
            }
            if (movingobjectposition.field_72310_e == 0) {
                --yCoord;
            }
            if (movingobjectposition.field_72310_e == 1) {
                ++yCoord;
            }
            if (movingobjectposition.field_72310_e == 2) {
                --zCoord;
            }
            if (movingobjectposition.field_72310_e == 3) {
                ++zCoord;
            }
            if (movingobjectposition.field_72310_e == 4) {
                --xCoord;
            }
            if (movingobjectposition.field_72310_e == 5) {
                ++xCoord;
            }
            if (!player.func_82247_a(xCoord, yCoord, zCoord, movingobjectposition.field_72310_e, itemStack)) {
                return itemStack;
            }
            if (this.func_77875_a(world, xCoord, yCoord, zCoord) && !player.field_71075_bZ.field_75098_d) {
                return new ItemStack(this.func_77668_q());
            }
        }
        return itemStack;
    }

    public boolean func_77875_a(World world, int xCoord, int yCoord, int zCoord) {
        if (this._fluidBlockId <= 0) {
            return false;
        }
        Material material = world.func_72803_f(xCoord, yCoord, zCoord);
        if (!world.func_72799_c(xCoord, yCoord, zCoord) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_94578_a(xCoord, yCoord, zCoord, true);
        }
        world.func_72832_d(xCoord, yCoord, zCoord, this._fluidBlockId, 0, 3);
        return true;
    }

    public void setCapcity(int capacity) {
        this._capacity = capacity;
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack == null) {
            return this.func_77658_a();
        }
        FluidStack fluidStack = this.getFluid(itemStack);
        if (fluidStack == null) {
            return this.func_77658_a();
        }
        String fluidName = fluidStack.getFluid().getName();
        return "item.extratic.bucket.filled." + fluidName;
    }

    public String func_77628_j(ItemStack itemStack) {
        if (itemStack == null) {
            return this.func_77658_a();
        }
        FluidStack fluidStack = this.getFluid(itemStack);
        if (fluidStack == null) {
            return this.func_77658_a();
        }
        if (StatCollector.func_94522_b((String)"item.bucket.name")) {
            String localizedBucket = StatCollector.func_74838_a((String)"item.bucket.name");
            String displayName = fluidStack.getFluid().getLocalizedName() + " " + localizedBucket;
            return displayName;
        }
        return this.func_77667_c(itemStack);
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack container) {
        return this._capacity;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.field_77990_d.func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int drained = Math.min(stack.amount, maxDrain);
        if (doDrain && maxDrain >= stack.amount) {
            container.field_77990_d.func_82580_o("Fluid");
            if (container.field_77990_d.func_82582_d()) {
                container.field_77990_d = null;
            }
            return stack;
        }
        stack.amount = drained;
        return stack;
    }

    public ItemStack setFluidInside(ItemStack itemStack, FluidStack fluidStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound fluidTag = fluidStack.writeToNBT(new NBTTagCompound());
        fluidTag.func_74768_a("Amount", this.getCapacity(itemStack));
        itemStack.field_77990_d.func_74782_a("Fluid", (NBTBase)fluidTag);
        return itemStack;
    }

    public void addTextureMaping(int id, String fluidName, String texture) {
        this.fluidNames.put((Object)id, (Object)fluidName);
        this.textures.put(id, texture);
    }

    public void func_77633_a(int id, CreativeTabs tab, List itemStackList) {
        if (!this.fluidNames.isEmpty()) {
            for (Map.Entry subItem : this.fluidNames.entrySet()) {
                int entryId = (Integer)subItem.getKey();
                ItemStack bucketStack = new ItemStack((Item)this);
                FluidStack fluidStack = FluidRegistry.getFluidStack((String)((String)subItem.getValue()), (int)this._capacity);
                if (fluidStack == null) continue;
                bucketStack = this.setFluidInside(bucketStack, fluidStack);
                itemStackList.add(bucketStack);
            }
        } else {
            itemStackList.add(new ItemStack((Item)this, 1));
        }
    }
}

