/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.gen;

import java.util.List;
import java.util.Random;
import net.gegy1000.earth.server.world.gen.EarthGen;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ChunkGeneratorEarth
implements IChunkGenerator {
    private final Random RANDOM;
    private final World WORLD;
    private Biome[] biomesForGeneration;
    private final EarthGen EARTH_GEN;
    private static final IBlockState STONE_BLOCK = Blocks.field_150348_b.func_176223_P();
    private static final IBlockState LIQUID_BLOCK = Blocks.field_150355_j.func_176223_P();
    private static final int OCEAN_HEIGHT = 59;

    public ChunkGeneratorEarth(World world, long seed, EarthGen earthGen) {
        this.WORLD = world;
        this.RANDOM = new Random(seed);
        this.EARTH_GEN = earthGen;
    }

    public void setBlocksInChunk(int chunkX, int chunkZ, ChunkPrimer chunkPrimer) {
        this.biomesForGeneration = this.WORLD.func_72959_q().func_76937_a(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        int chunkWorldX = chunkX * 16;
        int chunkWorldZ = chunkZ * 16;
        IBlockState stoneBlock = STONE_BLOCK;
        IBlockState liquidBlock = LIQUID_BLOCK;
        IBlockState bedrock = Blocks.field_150357_h.func_176223_P();
        int oceanHeight = 59;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int height = this.EARTH_GEN.getHeightForCoords(x + chunkWorldX, z + chunkWorldZ);
                chunkPrimer.func_177855_a(x, 0, z, bedrock);
                for (y = 1; y < height; ++y) {
                    chunkPrimer.func_177855_a(x, y, z, stoneBlock);
                }
                if (height >= oceanHeight) continue;
                for (y = height + 1; y <= oceanHeight; ++y) {
                    chunkPrimer.func_177855_a(x, y, z, liquidBlock);
                }
            }
        }
    }

    public void generateGrass(int chunkX, int chunkZ, ChunkPrimer chunkPrimer, Biome[] biomes) {
        ChunkGeneratorEvent.ReplaceBiomeBlocks event = new ChunkGeneratorEvent.ReplaceBiomeBlocks((IChunkGenerator)this, chunkX, chunkZ, chunkPrimer, this.WORLD);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        int worldChunkX = chunkX * 16;
        int worldChunkZ = chunkZ * 16;
        IBlockState bedrock = Blocks.field_150357_h.func_176223_P();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                Biome biome = biomes[x + z * 16];
                if (biome == null) continue;
                IBlockState topBlock = biome.field_76752_A;
                IBlockState fillerBlock = biome.field_76753_B;
                int surfaceDepth = 0;
                for (int y = height = this.EARTH_GEN.getHeightForCoords(x + worldChunkX, z + worldChunkZ); y >= 0; --y) {
                    if (y > 0 && y < 5 && y <= this.RANDOM.nextInt(5)) {
                        chunkPrimer.func_177855_a(x, y, z, bedrock);
                        continue;
                    }
                    if (surfaceDepth == 0) {
                        chunkPrimer.func_177855_a(x, y, z, topBlock);
                    } else if (surfaceDepth < 4) {
                        chunkPrimer.func_177855_a(x, y, z, fillerBlock);
                    } else if (surfaceDepth > 4 && y > 5) {
                        y = 5;
                    }
                    ++surfaceDepth;
                }
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        this.RANDOM.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer primer = new ChunkPrimer();
        this.setBlocksInChunk(x, z, primer);
        this.biomesForGeneration = this.WORLD.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.generateGrass(x, z, primer, this.biomesForGeneration);
        Chunk chunk = new Chunk(this.WORLD, primer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int biomeIndex = 0; biomeIndex < biomeArray.length; ++biomeIndex) {
            biomeArray[biomeIndex] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[biomeIndex]);
        }
        chunk.func_76603_b();
        this.EARTH_GEN.clearCache();
        return chunk;
    }

    public boolean func_185933_a(Chunk chunk, int x, int z) {
        return false;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        int x = chunkX * 16;
        int z = chunkZ * 16;
        BlockPos pos = new BlockPos(x, 0, z);
        Biome biome = this.WORLD.func_180494_b(pos.func_177982_a(16, 0, 16));
        this.RANDOM.setSeed(this.WORLD.func_72905_C());
        long i1 = this.RANDOM.nextLong() / 2L * 2L + 1L;
        long j1 = this.RANDOM.nextLong() / 2L * 2L + 1L;
        this.RANDOM.setSeed((long)chunkX * i1 + (long)chunkZ * j1 ^ this.WORLD.func_72905_C());
        boolean hasVillageGenerated = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre((IChunkGenerator)this, this.WORLD, this.RANDOM, chunkX, chunkZ, hasVillageGenerated));
        biome.func_180624_a(this.WORLD, this.RANDOM, new BlockPos(x, 0, z));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.WORLD, (Random)this.RANDOM, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.WORLD, (Biome)biome, (int)(x + 8), (int)(z + 8), (int)16, (int)16, (Random)this.RANDOM);
        }
        pos = pos.func_177982_a(8, 0, 8);
        boolean freeze = TerrainGen.populate((IChunkGenerator)this, (World)this.WORLD, (Random)this.RANDOM, (int)chunkX, (int)chunkZ, (boolean)hasVillageGenerated, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE);
        for (int xOffset = 0; freeze && xOffset < 16; ++xOffset) {
            for (int zOffset = 0; zOffset < 16; ++zOffset) {
                BlockPos top = this.WORLD.func_175725_q(pos.func_177982_a(xOffset, 0, zOffset));
                BlockPos ground = top.func_177977_b();
                if (this.WORLD.func_175675_v(ground)) {
                    this.WORLD.func_180501_a(ground, Blocks.field_150432_aD.func_176223_P(), 2);
                }
                if (!this.WORLD.func_175708_f(top, true)) continue;
                this.WORLD.func_180501_a(top, Blocks.field_150431_aC.func_176223_P(), 2);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post((IChunkGenerator)this, this.WORLD, this.RANDOM, chunkX, chunkZ, hasVillageGenerated));
        BlockFalling.field_149832_M = false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.WORLD.func_180494_b(pos).func_76747_a(creatureType);
    }

    public BlockPos func_180513_a(World world, String gen, BlockPos pos) {
        return pos;
    }

    public void func_180514_a(Chunk chunk, int x, int z) {
    }
}

