/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.gen;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.gegy1000.earth.server.world.gen.EarthGen;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BiomeProviderEarth
extends BiomeProvider {
    private final BiomeCache BIOME_CACHE = new BiomeCache((BiomeProvider)this);
    private final List<Biome> SPAWN_BIOMES = Lists.newArrayList();
    private final EarthGen GENERATOR;

    protected BiomeProviderEarth(EarthGen generator) {
        this.SPAWN_BIOMES.addAll(allowedBiomes);
        this.GENERATOR = generator;
    }

    public List<Biome> func_76932_a() {
        return this.SPAWN_BIOMES;
    }

    public Biome func_180631_a(BlockPos pos) {
        return this.loadBiomeFromCache(pos, null);
    }

    public Biome loadBiomeFromCache(BlockPos pos, Biome defaultBiome) {
        return this.BIOME_CACHE.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76939_a(float biomeTemperature, int height) {
        return biomeTemperature;
    }

    public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * height) {
            biomes = new Biome[width * height];
        }
        int i = 0;
        for (int partZ = 0; partZ < height; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                biomes[i] = this.getBiomeAt(partX + x, partZ + z);
                ++i;
            }
        }
        return biomes;
    }

    public Biome[] func_76933_b(Biome[] oldBiomes, int x, int z, int width, int depth) {
        return this.func_76931_a(oldBiomes, x, z, width, depth, true);
    }

    public Biome[] func_76931_a(Biome[] biomes, int x, int z, int width, int length, boolean cache) {
        IntCache.func_76446_a();
        if (biomes == null || biomes.length < width * length) {
            biomes = new Biome[width * length];
        }
        if (cache && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] cachedBiomes = this.BIOME_CACHE.func_76839_e(x, z);
            System.arraycopy(cachedBiomes, 0, biomes, 0, width * length);
            return biomes;
        }
        int i = 0;
        for (int partZ = 0; partZ < length; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                biomes[i] = this.getBiomeAt(partX + x, partZ + z);
                ++i;
            }
        }
        return biomes;
    }

    public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
        IntCache.func_76446_a();
        int minX = x - radius >> 2;
        int minZ = z - radius >> 2;
        int maxX = x + radius >> 2;
        int maxZ = z + radius >> 2;
        int width = maxX - minX + 1;
        int length = maxZ - minZ + 1;
        for (int partZ = 0; partZ < length; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                Biome biome = this.getBiomeAt(partX + x, partZ + z);
                if (allowed.contains(biome)) continue;
                return false;
            }
        }
        return true;
    }

    public BlockPos func_180630_a(int x, int z, int radius, List<Biome> biomes, Random random) {
        IntCache.func_76446_a();
        int minX = x - radius >> 2;
        int minZ = z - radius >> 2;
        int maxX = x + radius >> 2;
        int maxZ = z + radius >> 2;
        int width = maxX - minX + 1;
        int length = maxZ - minZ + 1;
        BlockPos pos = null;
        int j2 = 0;
        int i = 0;
        for (int partZ = 0; partZ < length; ++partZ) {
            for (int partX = 0; partX < width; ++partX) {
                int chunkX = minX + i % width << 2;
                int chunkZ = minZ + i / width << 2;
                Biome biome = this.getBiomeAt(partX + x, partZ + z);
                if (biomes.contains(biome) && (pos == null || random.nextInt(j2 + 1) == 0)) {
                    pos = new BlockPos(chunkX, 0, chunkZ);
                    ++j2;
                }
                ++i;
            }
        }
        return pos;
    }

    private Biome getBiomeAt(int x, int z) {
        return this.GENERATOR.getBiomeForCoords(x, z);
    }

    public void func_76938_b() {
        this.BIOME_CACHE.func_76838_a();
    }

    public GenLayer[] getModdedBiomeerators(WorldType type, long seed, GenLayer[] original) {
        WorldTypeEvent.InitBiomeGens event = new WorldTypeEvent.InitBiomeGens(type, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.getNewBiomeGens();
    }
}

