/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.worldGeneration;

import com.DavidM1A2.AfraidOfTheDark.common.block.BlockAstralSilverOre;
import com.DavidM1A2.AfraidOfTheDark.common.initializeMod.ModBlocks;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.AOTDMeteorTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class CreateMeteor {
    private static final List<Block> replaceableBlocks = new ArrayList<Block>(){
        {
            this.add(ModBlocks.astralSilverOre);
            this.add(ModBlocks.starMetalOre);
            this.add(ModBlocks.sunstoneOre);
            this.add(ModBlocks.meteor);
            this.add(Blocks.field_150346_d);
            this.add(Blocks.field_150349_c);
            this.add(Blocks.field_150362_t);
            this.add(Blocks.field_150361_u);
            this.add(Blocks.field_150354_m);
            this.add(Blocks.field_150364_r);
            this.add(Blocks.field_150363_s);
            this.add(Blocks.field_150395_bd);
            this.add(Blocks.field_150330_I);
            this.add(Blocks.field_150398_cm);
            this.add(Blocks.field_150432_aD);
            this.add(Blocks.field_150350_a);
            this.add(Blocks.field_150348_b);
            this.add(Blocks.field_150351_n);
            this.add(Blocks.field_150322_A);
            this.add(Blocks.field_150433_aE);
            this.add(Blocks.field_150431_aC);
        }
    };

    public static void create(World world, BlockPos location, int radius, int height, boolean hollow, boolean isSphere, AOTDMeteorTypes type) {
        int cx = location.func_177958_n();
        int cy = CreateMeteor.makeSureChunkIsGenerated(world, location);
        int cz = location.func_177952_p();
        for (int x = cx - radius; x <= cx + radius; ++x) {
            for (int z = cz - radius; z <= cz + radius; ++z) {
                for (int y = isSphere ? cy - radius : cy; y < (isSphere ? cy + radius : cy + height); ++y) {
                    Block current;
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (isSphere ? (cy - y) * (cy - y) : 0);
                    if (!(dist < (double)(radius * radius)) || hollow && dist < (double)((radius - 1) * (radius - 1)) || !replaceableBlocks.contains(current = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) && current.func_149688_o() != Material.field_151586_h && current.func_149688_o() != Material.field_151587_i) continue;
                    world.func_175656_a(new BlockPos(x, y, z), ModBlocks.meteor.func_176223_P());
                }
            }
        }
        CreateMeteor.createCore(world, new BlockPos(cx, cy, cz), MathHelper.func_76143_f((double)((double)radius / 2.5)), MathHelper.func_76143_f((double)((double)height / 2.5)), hollow, isSphere, type);
    }

    private static void createCore(World world, BlockPos location, int radius, int height, boolean hollow, boolean isSphere, AOTDMeteorTypes type) {
        BlockAstralSilverOre toPlace = type == AOTDMeteorTypes.silver ? ModBlocks.astralSilverOre : (type == AOTDMeteorTypes.sunstone ? ModBlocks.sunstoneOre : ModBlocks.starMetalOre);
        int cx = location.func_177958_n();
        int cy = location.func_177956_o();
        int cz = location.func_177952_p();
        for (int x = cx - radius; x <= cx + radius; ++x) {
            for (int z = cz - radius; z <= cz + radius; ++z) {
                for (int y = isSphere ? cy - radius : cy; y < (isSphere ? cy + radius : cy + height); ++y) {
                    Block current;
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (isSphere ? (cy - y) * (cy - y) : 0);
                    if (!(dist < (double)(radius * radius)) || hollow && dist < (double)((radius - 1) * (radius - 1)) || !replaceableBlocks.contains(current = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) && current.func_149688_o() != Material.field_151586_h && current.func_149688_o() != Material.field_151587_i) continue;
                    world.func_175656_a(new BlockPos(x, y, z), toPlace.func_176223_P());
                }
            }
        }
    }

    private static int makeSureChunkIsGenerated(World world, BlockPos location) {
        if (!world.func_72863_F().func_73149_a(location.func_177958_n(), location.func_177952_p())) {
            world.func_72863_F().func_73154_d(location.func_177958_n(), location.func_177952_p());
        }
        while (world.func_180495_p(location).func_177230_c() instanceof BlockAir || world.func_180495_p(location).func_177230_c().func_149688_o() == Material.field_151586_h) {
            location = new BlockPos(location.func_177958_n(), location.func_177956_o() - 1, location.func_177952_p());
        }
        return location.func_177956_o();
    }
}

