/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.worldGeneration;

import com.DavidM1A2.AfraidOfTheDark.common.biomes.BiomeErieForest;
import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDWorldData;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.GenerateCrypt;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.GenerateDarkForestDungeon;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.GenerateGnomishCity;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.GenerateSprings;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.GenerateVoidChest;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.GenerateWitchHut;
import java.util.Random;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenPlains;
import net.minecraft.world.biome.BiomeGenSavanna;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class AOTDWorldGenerationHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.func_177502_q()) {
            case 0: {
                AOTDWorldData.register(world);
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int chunkX, int chunkZ) {
        BiomeGenBase current = world.func_180494_b(new BlockPos(chunkX, 50, chunkZ));
        if (current instanceof BiomeGenPlains) {
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.gnomishCityFrequency * 0.375 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateGnomishCity.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.darkForestFrequency * 0.3 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateDarkForestDungeon.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.springFrequency * 0.5 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateSprings.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
        } else if (current instanceof BiomeErieForest) {
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.gnomishCityFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateGnomishCity.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.darkForestFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateDarkForestDungeon.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.cryptFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateCrypt.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.springFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateSprings.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.witchHutFrequency * 0.5 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateWitchHut.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
        } else if (current instanceof BiomeGenSavanna) {
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.gnomishCityFrequency * 0.5 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateGnomishCity.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.darkForestFrequency * 0.6 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateDarkForestDungeon.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.springFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateSprings.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
        } else if (current instanceof BiomeGenSwamp) {
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.witchHutFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateWitchHut.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
        } else if (current instanceof BiomeGenSnow) {
            if (random.nextDouble() * 100.0 < (double)ConfigurationHandler.gnomishCityFrequency * 0.5 * (double)ConfigurationHandler.dungeonFrequencyMultiplier && GenerateGnomishCity.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
            if (random.nextDouble() * 100.0 < (double)(ConfigurationHandler.voidChestFrequency * ConfigurationHandler.dungeonFrequencyMultiplier) && GenerateVoidChest.generateSurface(world, random, chunkX, chunkZ)) {
                return;
            }
        }
    }
}

