/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.utility;

import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveHandler;

public class NBTHelper {
    public static List<NBTTagCompound> getOfflinePlayerNBTs() {
        LinkedList<NBTTagCompound> toReturn = new LinkedList<NBTTagCompound>();
        ISaveHandler iSaveHandler = MinecraftServer.func_71276_C().field_71305_c[0].func_72860_G();
        if (iSaveHandler instanceof SaveHandler) {
            SaveHandler saveHandler = (SaveHandler)iSaveHandler;
            File playersDirectory = new File(saveHandler.func_75765_b(), "playerdata");
            for (String username : saveHandler.func_75754_f()) {
                File playerData = new File(playersDirectory, username + ".dat");
                if (!playerData.exists() || !playerData.isFile()) continue;
                try {
                    NBTTagCompound playerDataCompound = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(playerData));
                    if (playerDataCompound == null) continue;
                    toReturn.add(playerDataCompound);
                }
                catch (Exception e) {
                    LogHelper.info("Error reading player data for username " + username);
                }
            }
        }
        return toReturn;
    }

    public static boolean hasTag(ItemStack itemStack, String keyName) {
        return itemStack != null && itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b(keyName);
    }

    public static void removeTag(ItemStack itemStack, String keyName) {
        if (itemStack.func_77978_p() != null) {
            itemStack.func_77978_p().func_82580_o(keyName);
        }
    }

    private static void initNBTTagCompound(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public static void setLong(ItemStack itemStack, String keyName, long keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74772_a(keyName, keyValue);
    }

    public static String getString(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setString(itemStack, keyName, "");
        }
        return itemStack.func_77978_p().func_74779_i(keyName);
    }

    public static void setString(ItemStack itemStack, String keyName, String keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74778_a(keyName, keyValue);
    }

    public static boolean getBoolean(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setBoolean(itemStack, keyName, false);
        }
        return itemStack.func_77978_p().func_74767_n(keyName);
    }

    public static void setBoolean(ItemStack itemStack, String keyName, boolean keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74757_a(keyName, keyValue);
    }

    public static byte getByte(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setByte(itemStack, keyName, (byte)0);
        }
        return itemStack.func_77978_p().func_74771_c(keyName);
    }

    public static void setByte(ItemStack itemStack, String keyName, byte keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74774_a(keyName, keyValue);
    }

    public static short getShort(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setShort(itemStack, keyName, (short)0);
        }
        return itemStack.func_77978_p().func_74765_d(keyName);
    }

    public static void setShort(ItemStack itemStack, String keyName, short keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74777_a(keyName, keyValue);
    }

    public static int getInt(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setInteger(itemStack, keyName, 0);
        }
        return itemStack.func_77978_p().func_74762_e(keyName);
    }

    public static void setInteger(ItemStack itemStack, String keyName, int keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74768_a(keyName, keyValue);
    }

    public static long getLong(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setLong(itemStack, keyName, 0L);
        }
        return itemStack.func_77978_p().func_74763_f(keyName);
    }

    public static float getFloat(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setFloat(itemStack, keyName, 0.0f);
        }
        return itemStack.func_77978_p().func_74760_g(keyName);
    }

    public static void setFloat(ItemStack itemStack, String keyName, float keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74776_a(keyName, keyValue);
    }

    public static double getDouble(ItemStack itemStack, String keyName) {
        NBTHelper.initNBTTagCompound(itemStack);
        if (!itemStack.func_77978_p().func_74764_b(keyName)) {
            NBTHelper.setDouble(itemStack, keyName, 0.0);
        }
        return itemStack.func_77978_p().func_74769_h(keyName);
    }

    public static void setDouble(ItemStack itemStack, String keyName, double keyValue) {
        NBTHelper.initNBTTagCompound(itemStack);
        itemStack.func_77978_p().func_74780_a(keyName, keyValue);
    }
}

