/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.spell;

import com.DavidM1A2.AfraidOfTheDark.common.spell.Spell;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class SpellManager
implements Serializable {
    private BiMap<Character, UUID> keyToSpell = HashBiMap.create();
    private BiMap<UUID, Spell> spells = HashBiMap.create();

    public void addSpell(Spell spell) {
        this.spells.put((Object)spell.getSpellUUID(), (Object)spell);
    }

    public void removeSpell(Spell spell) {
        this.spells.remove((Object)spell.getSpellUUID());
    }

    public Collection<Spell> getSpellList() {
        return this.spells.values();
    }

    public void addKeybindingToSpell(char key, Spell spell) {
        this.keyToSpell.put((Object)Character.valueOf(key), (Object)spell.getSpellUUID());
    }

    public void removeKeybindingToSpell(char key, Spell spell) {
        this.keyToSpell.remove((Object)Character.valueOf(key), (Object)spell.getSpellUUID());
    }

    public void setAllSpellsOwners(EntityPlayer owner) {
        for (Spell spell : this.spells.values()) {
            spell.setSpellOwner(owner);
        }
    }

    public void keyPressed(int keyCode, char key) {
        if (this.doesKeyMapToSpell(key)) {
            ((Spell)this.spells.get(this.keyToSpell.get((Object)Character.valueOf(key)))).instantiateSpell();
        }
    }

    public boolean doesKeyMapToSpell(char key) {
        return this.keyToSpell.containsKey((Object)Character.valueOf(key)) && this.spells.containsKey(this.keyToSpell.get((Object)Character.valueOf(key)));
    }

    public Character keyFromSpell(Spell spell) {
        Character key;
        UUID current = (UUID)this.spells.inverse().get((Object)spell);
        if (current != null && (key = (Character)this.keyToSpell.inverse().get((Object)current)) != null) {
            return key;
        }
        return null;
    }
}

