/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.spell;

import com.DavidM1A2.AfraidOfTheDark.common.spell.deliveryMethods.IDeliveryMethod;
import com.DavidM1A2.AfraidOfTheDark.common.spell.effects.IEffect;
import com.DavidM1A2.AfraidOfTheDark.common.spell.powerSources.IPowerSource;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Utility;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class Spell
implements Serializable {
    private final String name;
    private final IPowerSource powerSource;
    private final Map.Entry<IDeliveryMethod, List<IEffect>>[] spellStages;
    private final UUID spellID;
    private transient EntityPlayer spellOwner;

    public Spell(String name, IPowerSource powerSource, LinkedHashMap<IDeliveryMethod, List<IEffect>> spellStages, UUID spellID) {
        this.name = name;
        this.spellStages = new Map.Entry[spellStages.entrySet().size()];
        spellStages.entrySet().toArray(this.spellStages);
        this.powerSource = powerSource;
        this.spellID = spellID;
    }

    public void instantiateSpell() {
        if (this.isSpellValid() && this.powerSource.attemptToCast(this)) {
            this.getSpellOwner().field_70170_p.func_72838_d((Entity)this.spellStages[0].getKey().createSpellEntity(this));
        } else if (!this.isSpellValid()) {
            this.spellOwner.func_145747_a((IChatComponent)new ChatComponentText("Invalid spell. Make sure to have delivery methods and a power source on your spell!"));
        } else {
            this.spellOwner.func_145747_a((IChatComponent)new ChatComponentText(this.powerSource.notEnoughEnergyMsg()));
        }
    }

    public double getCost() {
        double cost = 0.0;
        for (Map.Entry<IDeliveryMethod, List<IEffect>> spellStage : this.spellStages) {
            cost += spellStage.getKey().getCost();
            for (IEffect effect : spellStage.getValue()) {
                cost += (double)effect.getCost();
            }
        }
        return cost;
    }

    private boolean isSpellValid() {
        boolean isValid = true;
        if (this.powerSource == null) {
            isValid = false;
        }
        if (this.spellStages.length == 0) {
            isValid = false;
        }
        for (Map.Entry<IDeliveryMethod, List<IEffect>> spellStage : this.spellStages) {
            if (spellStage.getKey() != null) continue;
            isValid = false;
        }
        return isValid;
    }

    public Map.Entry<IDeliveryMethod, List<IEffect>> getSpellStageByIndex(int index) {
        if (!this.hasSpellStage(index)) {
            return null;
        }
        return this.spellStages[index];
    }

    public boolean hasSpellStage(int index) {
        return Utility.hasIndex(this.spellStages, index);
    }

    public void setSpellOwner(EntityPlayer spellOwner) {
        this.spellOwner = spellOwner;
    }

    public EntityPlayer getSpellOwner() {
        return this.spellOwner;
    }

    public String getName() {
        return this.name;
    }

    public UUID getSpellUUID() {
        return this.spellID;
    }
}

