/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.schematic;

import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.schematic.Schematic;
import com.DavidM1A2.AfraidOfTheDark.common.schematic.SchematicBlockReplacer;
import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SchematicLoader {
    public static Schematic load(String schemname) {
        try {
            InputStream schematicInputStream = Utility.getInputStreamFromPath("assets/afraidofthedark/schematics/" + schemname);
            NBTTagCompound nbtdata = CompressedStreamTools.func_74796_a((InputStream)schematicInputStream);
            schematicInputStream.close();
            short width = nbtdata.func_74765_d("Width");
            short height = nbtdata.func_74765_d("Height");
            short length = nbtdata.func_74765_d("Length");
            byte[] blocks = nbtdata.func_74770_j("Blocks");
            byte[] data = nbtdata.func_74770_j("Data");
            NBTTagList tileentities = nbtdata.func_150295_c("TileEntities", 10);
            NBTTagList entities = nbtdata.func_150295_c("Entities", 10);
            Schematic toReturn = new Schematic(tileentities, width, height, length, SchematicLoader.byteArrayToShortArray(blocks), data, entities);
            SchematicBlockReplacer.fixKnownSchematicErrors(toReturn);
            if (ConfigurationHandler.debugMessages) {
                SchematicLoader.printIncorrectIds(toReturn.getBlocks(), schemname);
            }
            return toReturn;
        }
        catch (IOException e) {
            System.out.println("I can't load schematic: " + schemname + ", because " + e.toString() + "\nMessage: " + e.getMessage());
            return null;
        }
    }

    private static short[] byteArrayToShortArray(byte[] byteArray) {
        short[] toReturn = new short[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            toReturn[i] = byteArray[i];
        }
        return toReturn;
    }

    private static void printIncorrectIds(short[] blocks, String schematicName) {
        ArrayList<Short> incorrectIds = new ArrayList<Short>();
        int[] numberOfIncorrect = new int[20000];
        for (short b : blocks) {
            if (b < 0 && !incorrectIds.contains(b)) {
                incorrectIds.add(b);
                numberOfIncorrect[Math.abs((int)b)] = 1;
                continue;
            }
            if (b >= 0) continue;
            numberOfIncorrect[Math.abs((int)b)] = numberOfIncorrect[Math.abs(b)] + 1;
        }
        Object object = incorrectIds.iterator();
        while (object.hasNext()) {
            short b = (Short)object.next();
            LogHelper.info(numberOfIncorrect[Math.abs(b)] + " incorrect ids of the id " + b + " found in the schematic " + schematicName + ".");
        }
    }
}

