/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.schematic;

import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.initializeMod.ModBlocks;
import com.DavidM1A2.AfraidOfTheDark.common.schematic.Schematic;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Point3D;
import com.DavidM1A2.AfraidOfTheDark.common.utility.WorldGenerationUtility;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.loot.LootTable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public final class SchematicGenerator {
    private static final Set<Short> latePlacePriorityBlocks = new HashSet<Short>(){
        {
            this.add((short)Block.func_149682_b((Block)Blocks.field_150448_aq));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150436_aH));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150455_bV));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150416_aS));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150345_g));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150319_E));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150429_aA));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150395_bd));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150472_an));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150444_as));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150488_af));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150478_aa));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150471_bO));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150430_aB));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150452_aw));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150456_au));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150445_bS));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150443_bT));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150330_I));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150324_C));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150415_aT));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150404_cg));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150454_av));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150468_ap));
            this.add((short)Block.func_149682_b((Block)Blocks.field_180409_at));
            this.add((short)Block.func_149682_b((Block)Blocks.field_180412_aq));
            this.add((short)Block.func_149682_b((Block)Blocks.field_180413_ao));
            this.add((short)Block.func_149682_b((Block)Blocks.field_180410_as));
            this.add((short)Block.func_149682_b((Block)Blocks.field_180414_ap));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150398_cm));
        }
    };
    private static final Set<Short> lightUpdateBlocks = new HashSet<Short>(){
        {
            this.add((short)Block.func_149682_b((Block)Blocks.field_150426_aN));
            this.add((short)Block.func_149682_b((Block)Blocks.field_150478_aa));
            this.add((short)Block.func_149682_b((Block)ModBlocks.glowStalk));
        }
    };
    private static final int DIAMOND_BLOCK_ID = Block.func_149682_b((Block)Blocks.field_150484_ah);
    private static final int AIR_BLOCK_ID = Block.func_149682_b((Block)Blocks.field_150350_a);

    public static void generateSchematic(Schematic schematic, World world, int xPosition, int yPosition, int zPosition) {
        if (schematic == null) {
            return;
        }
        SchematicGenerator.generateBlocks(schematic, world, xPosition, yPosition, zPosition);
        SchematicGenerator.loadTileEntities(schematic, world, xPosition, yPosition, zPosition);
        SchematicGenerator.loadEntities(schematic, world, xPosition, yPosition, zPosition);
    }

    public static void generateSchematicWithLoot(Schematic schematic, World world, int xPosition, int yPosition, int zPosition, LootTable lootTable) {
        if (schematic == null) {
            return;
        }
        SchematicGenerator.generateBlocks(schematic, world, xPosition, yPosition, zPosition);
        SchematicGenerator.loadTileEntitiesWithLoot(schematic, world, xPosition, yPosition, zPosition, lootTable);
        SchematicGenerator.loadEntities(schematic, world, xPosition, yPosition, zPosition);
    }

    private static void generateBlocks(Schematic schematic, World world, int xPosition, int yPosition, int zPosition) {
        int i = 0;
        LinkedList<Short> blocksToPlaceLater = new LinkedList<Short>();
        LinkedList<Byte> blocksToPlaceLaterMeta = new LinkedList<Byte>();
        LinkedList<Point3D> laterBlockPositions = new LinkedList<Point3D>();
        LinkedList<Point3D> lightBlockPositions = new LinkedList<Point3D>();
        for (int y = 0; y < schematic.getHeight(); ++y) {
            for (int z = 0; z < schematic.getLength(); ++z) {
                for (int x = 0; x < schematic.getWidth(); ++x) {
                    short nextToPlace = schematic.getBlocks()[i];
                    if (nextToPlace != AIR_BLOCK_ID) {
                        if (nextToPlace == DIAMOND_BLOCK_ID) {
                            WorldGenerationUtility.setBlockStateFast(world, new BlockPos(x + xPosition, y + yPosition, z + zPosition), Blocks.field_150350_a.func_176223_P(), 3);
                        } else if (latePlacePriorityBlocks.contains(schematic.getBlocks()[i])) {
                            blocksToPlaceLater.add(schematic.getBlocks()[i]);
                            blocksToPlaceLaterMeta.add(schematic.getData()[i]);
                            laterBlockPositions.add(new Point3D(x + xPosition, y + yPosition, z + zPosition));
                        } else {
                            WorldGenerationUtility.setBlockStateFast(world, new BlockPos(x + xPosition, y + yPosition, z + zPosition), Block.func_149729_e((int)nextToPlace).func_176203_a((int)schematic.getData()[i]), 3);
                        }
                        if (ConfigurationHandler.enableWorldGenLightUpdates && lightUpdateBlocks.contains(schematic.getBlocks()[i])) {
                            lightBlockPositions.add(new Point3D(x + xPosition, y + yPosition, z + zPosition));
                        }
                    }
                    ++i;
                }
            }
        }
        Iterator iteratorBlock = blocksToPlaceLater.iterator();
        Iterator iteratorMeta = blocksToPlaceLaterMeta.iterator();
        Iterator iteratorLocation = laterBlockPositions.iterator();
        while (iteratorBlock.hasNext()) {
            Block next = Block.func_149729_e((int)((Short)iteratorBlock.next()).shortValue());
            IBlockState blockState = next.func_176203_a((int)((Byte)iteratorMeta.next()).byteValue());
            BlockPos blockPos = ((Point3D)iteratorLocation.next()).toBlockPos();
            if (next instanceof BlockDoor) {
                if (!((BlockDoor.EnumDoorHalf)blockState.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) continue;
                WorldGenerationUtility.setBlockStateFast(world, blockPos, blockState, 3);
                WorldGenerationUtility.setBlockStateFast(world, blockPos.func_177972_a(EnumFacing.UP), blockState.func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER), 3);
                continue;
            }
            WorldGenerationUtility.setBlockStateFast(world, blockPos, blockState, 3);
        }
        Iterator blockLocationsToUpdate = lightBlockPositions.iterator();
        while (blockLocationsToUpdate.hasNext()) {
            world.func_175664_x(((Point3D)blockLocationsToUpdate.next()).toBlockPos());
        }
    }

    private static void loadTileEntities(Schematic schematic, World world, int xPosition, int yPosition, int zPosition) {
        if (schematic.getTileentities() != null) {
            for (int j = 0; j < schematic.getTileentities().func_74745_c(); ++j) {
                NBTTagCompound tileEntityCompound = schematic.getTileentities().func_150305_b(j);
                TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntityCompound);
                if (tileEntity == null) continue;
                BlockPos tileEntityLocation = new BlockPos(tileEntity.func_174877_v().func_177958_n() + xPosition, tileEntity.func_174877_v().func_177956_o() + yPosition, tileEntity.func_174877_v().func_177952_p() + zPosition);
                world.func_175713_t(tileEntityLocation);
                world.func_175690_a(tileEntityLocation, tileEntity);
                tileEntity.func_174878_a(tileEntityLocation);
            }
        }
    }

    private static void loadTileEntitiesWithLoot(Schematic schematic, World world, int xPosition, int yPosition, int zPosition, LootTable lootTable) {
        if (schematic.getTileentities() != null) {
            for (int j = 0; j < schematic.getTileentities().func_74745_c(); ++j) {
                TileEntityChest tileEntityChest;
                NBTTagCompound tileEntityCompound = schematic.getTileentities().func_150305_b(j);
                TileEntity tileEntity = TileEntity.func_145827_c((NBTTagCompound)tileEntityCompound);
                if (tileEntity == null) continue;
                BlockPos tileEntityLocation = new BlockPos(tileEntity.func_174877_v().func_177958_n() + xPosition, tileEntity.func_174877_v().func_177956_o() + yPosition, tileEntity.func_174877_v().func_177952_p() + zPosition);
                world.func_175713_t(tileEntityLocation);
                world.func_175690_a(tileEntityLocation, tileEntity);
                tileEntity.func_174878_a(tileEntityLocation);
                if (!(tileEntity instanceof TileEntityChest) || (tileEntityChest = (TileEntityChest)world.func_175625_s(tileEntityLocation)) == null) continue;
                lootTable.generate(tileEntityChest);
            }
        }
    }

    private static void loadEntities(Schematic schematic, World world, int xPosition, int yPosition, int zPosition) {
        if (schematic.getEntities() != null) {
            for (int j = 0; j < schematic.getEntities().func_74745_c(); ++j) {
                NBTTagCompound entityCompound = schematic.getEntities().func_150305_b(j);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
                if (entity == null) continue;
                entity.func_70107_b(entity.field_70165_t + (double)xPosition, entity.field_70163_u + (double)yPosition, entity.field_70161_v + (double)zPosition);
                world.func_72838_d(entity);
            }
        }
    }
}

