/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.savedData;

import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTObjectWriter;
import com.DavidM1A2.AfraidOfTheDark.common.utility.Point3D;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class AOTDWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "AOTDWorldData";
    private Set<Point3D> dungeonsAboveGround = new HashSet<Point3D>();
    private Set<Point3D> dungeonsBelowGround = new HashSet<Point3D>();

    public AOTDWorldData() {
        super(AOTDWorldData.getIdentifier());
    }

    public AOTDWorldData(String string) {
        super(AOTDWorldData.getIdentifier());
    }

    private static String getIdentifier() {
        return IDENTIFIER;
    }

    public static AOTDWorldData get(World world) {
        return (AOTDWorldData)world.func_72943_a(AOTDWorldData.class, AOTDWorldData.getIdentifier());
    }

    public static void register(World world) {
        if (world.func_72943_a(AOTDWorldData.class, AOTDWorldData.getIdentifier()) == null) {
            world.func_72823_a(AOTDWorldData.getIdentifier(), (WorldSavedData)new AOTDWorldData());
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.dungeonsAboveGround = (Set)NBTObjectWriter.readObjectFromNBT("AOTDDungeonsAboveGround", nbt);
        if (this.dungeonsAboveGround == null) {
            this.dungeonsAboveGround = new HashSet<Point3D>();
        }
        this.dungeonsBelowGround = (Set)NBTObjectWriter.readObjectFromNBT("AOTDDungeonsBelowGround", nbt);
        if (this.dungeonsBelowGround == null) {
            this.dungeonsBelowGround = new HashSet<Point3D>();
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTObjectWriter.writeObjectToNBT("AOTDDungeonsAboveGround", this.dungeonsAboveGround, nbt);
        NBTObjectWriter.writeObjectToNBT("AOTDDungeonsBelowGround", this.dungeonsBelowGround, nbt);
    }

    public void addDungeon(Point3D location, boolean isAboveGround) {
        if (isAboveGround) {
            this.dungeonsAboveGround.add(location);
        } else {
            this.dungeonsBelowGround.add(location);
        }
        this.func_76185_a();
    }

    public boolean isValidLocation(Point3D location, boolean isAboveGround) {
        if (isAboveGround) {
            for (Point3D otherLocation : this.dungeonsAboveGround) {
                double distance = Math.sqrt((otherLocation.getZ() - location.getZ()) * (otherLocation.getZ() - location.getZ()) + (otherLocation.getX() - location.getX()) * (otherLocation.getX() - location.getX()));
                if (!(distance <= (double)(location.getY() + otherLocation.getY()))) continue;
                return false;
            }
        } else {
            for (Point3D otherLocation : this.dungeonsBelowGround) {
                double distance = Math.sqrt((otherLocation.getZ() - location.getZ()) * (otherLocation.getZ() - location.getZ()) + (otherLocation.getX() - location.getX()) * (otherLocation.getX() - location.getX()));
                if (!(distance <= (double)(location.getY() + otherLocation.getY()))) continue;
                return false;
            }
        }
        return true;
    }

    public Set<Point3D> getDungeonsAboveGround() {
        return this.dungeonsAboveGround;
    }

    public Set<Point3D> getDungeonsBelowGround() {
        return this.dungeonsBelowGround;
    }
}

