/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.savedData;

import com.DavidM1A2.AfraidOfTheDark.AfraidOfTheDark;
import com.DavidM1A2.AfraidOfTheDark.client.settings.ClientData;
import com.DavidM1A2.AfraidOfTheDark.common.initializeMod.ModItems;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncAOTDPlayerData;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncSelectedWristCrossbowBolt;
import com.DavidM1A2.AfraidOfTheDark.common.packets.UpdateAOTDStatus;
import com.DavidM1A2.AfraidOfTheDark.common.packets.UpdateHasBeatenEnaria;
import com.DavidM1A2.AfraidOfTheDark.common.packets.UpdateInsanity;
import com.DavidM1A2.AfraidOfTheDark.common.packets.UpdateResearch;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.ResearchTypes;
import com.DavidM1A2.AfraidOfTheDark.common.spell.SpellManager;
import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTObjectWriter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class AOTDPlayerData
implements IExtendedEntityProperties {
    private final EntityPlayer entityPlayer;
    private boolean hasStartedAOTD = false;
    private double playerInsanity;
    private NBTTagList inventoryList = new NBTTagList();
    private int[] playerLocationOverworld = new int[3];
    private int playerLocationNightmare;
    private int playerLocationVoidChest;
    private NBTTagCompound researches = new NBTTagCompound();
    private boolean hasBeatenEnaria;
    private int selectedWristCrossbowBolt = 0;
    private SpellManager spellManager = new SpellManager();
    private static final String HAS_STARTED_AOTD = "playerStartedAOTD";
    private static final String PLAYER_INSANITY = "PlayerInsanity";
    private static final String INVENTORY_SAVER = "inventorySaver";
    private static final String PLAYER_LOCATION_OVERWORLD = "playerLocationOverworld";
    private static final String PLAYER_LOCATION_NIGHTMARE = "playerLocationNightmare";
    private static final String PLAYER_LOCATION_VOID_CHEST = "playerLocationVoidChest";
    private static final String RESEARCH_DATA = "unlockedResearches";
    private static final String HAS_BEATEN_ENARIA = "hasBeatenEnaria";
    private static final String SELECTED_WRIST_CROSSBOW_BOLT = "selectedWristCrossbowBolt";
    private static final String SPELL_MANAGER = "spellManager";

    public AOTDPlayerData(EntityPlayer entityPlayer) {
        this.entityPlayer = entityPlayer;
    }

    private static String getIdentifier() {
        return "AOTDPlayerData";
    }

    public static AOTDPlayerData get(EntityPlayer entityPlayer) {
        return (AOTDPlayerData)entityPlayer.getExtendedProperties(AOTDPlayerData.getIdentifier());
    }

    public static void register(EntityPlayer entityPlayer) {
        if (entityPlayer.getExtendedProperties(AOTDPlayerData.getIdentifier()) == null) {
            entityPlayer.registerExtendedProperties(AOTDPlayerData.getIdentifier(), (IExtendedEntityProperties)new AOTDPlayerData(entityPlayer));
        }
    }

    public void saveNBTData(NBTTagCompound nbt) {
        nbt.func_74757_a(HAS_STARTED_AOTD, this.getHasStartedAOTD());
        nbt.func_74780_a(PLAYER_INSANITY, this.getPlayerInsanity());
        nbt.func_74782_a(INVENTORY_SAVER, (NBTBase)this.inventoryList);
        nbt.func_74783_a(PLAYER_LOCATION_OVERWORLD, this.playerLocationOverworld);
        nbt.func_74768_a(PLAYER_LOCATION_NIGHTMARE, this.playerLocationNightmare);
        nbt.func_74782_a(RESEARCH_DATA, (NBTBase)this.researches);
        nbt.func_74768_a(PLAYER_LOCATION_VOID_CHEST, this.playerLocationVoidChest);
        nbt.func_74757_a(HAS_BEATEN_ENARIA, this.hasBeatenEnaria);
        nbt.func_74768_a(SELECTED_WRIST_CROSSBOW_BOLT, this.selectedWristCrossbowBolt);
        NBTObjectWriter.writeObjectToNBT(SPELL_MANAGER, this.spellManager, nbt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        this.setHasStartedAOTD(nbt.func_74767_n(HAS_STARTED_AOTD));
        this.setPlayerInsanity(nbt.func_74769_h(PLAYER_INSANITY));
        this.setPlayerInventory(nbt.func_150295_c(INVENTORY_SAVER, 10));
        this.setPlayerLocationOverworld(nbt.func_74759_k(PLAYER_LOCATION_OVERWORLD));
        this.setPlayerLocationNightmare(nbt.func_74762_e(PLAYER_LOCATION_NIGHTMARE));
        this.setReseraches((NBTTagCompound)nbt.func_74781_a(RESEARCH_DATA));
        this.setPlayerLocationVoidChest(nbt.func_74762_e(PLAYER_LOCATION_VOID_CHEST));
        this.setHasBeatenEnaria(nbt.func_74767_n(HAS_BEATEN_ENARIA));
        this.setSelectedWristCrossbowBolt(nbt.func_74762_e(SELECTED_WRIST_CROSSBOW_BOLT));
        this.spellManager = (SpellManager)NBTObjectWriter.readObjectFromNBT(SPELL_MANAGER, nbt);
        if (this.spellManager == null) {
            this.spellManager = new SpellManager();
        }
        this.spellManager.setAllSpellsOwners(this.entityPlayer);
    }

    public void init(Entity entity, World world) {
    }

    public boolean isServerSide() {
        return this.entityPlayer instanceof EntityPlayerMP;
    }

    public boolean getHasStartedAOTD() {
        return this.hasStartedAOTD;
    }

    public void setHasStartedAOTD(boolean hasStartedAOTD) {
        this.hasStartedAOTD = hasStartedAOTD;
    }

    public void syncHasStartedAOTD() {
        if (this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendTo(new UpdateAOTDStatus(this.getHasStartedAOTD()), (EntityPlayerMP)this.entityPlayer);
        } else {
            AfraidOfTheDark.getPacketHandler().sendToServer(new UpdateAOTDStatus(this.getHasStartedAOTD()));
        }
    }

    public double getPlayerInsanity() {
        return this.playerInsanity;
    }

    public void setPlayerInsanity(double insanity) {
        this.playerInsanity = MathHelper.func_151237_a((double)insanity, (double)0.0, (double)100.0);
    }

    public void syncPlayerInsanity() {
        if (this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendTo(new UpdateInsanity(this.getPlayerInsanity()), (EntityPlayerMP)this.entityPlayer);
        }
    }

    public NBTTagList getPlayerInventory() {
        return this.inventoryList;
    }

    public void setPlayerInventory(NBTTagList inventory) {
        this.inventoryList = inventory;
    }

    public int[] getPlayerLocationOverworld() {
        return this.playerLocationOverworld;
    }

    public void setPlayerLocationOverworld(int[] location) {
        this.playerLocationOverworld = location;
    }

    public int getPlayerLocationNightmare() {
        return this.playerLocationNightmare;
    }

    public static int getPlayerLocationNightmareOffline(NBTTagCompound nbt) {
        return nbt.func_74775_l("ForgeData").func_74762_e(PLAYER_LOCATION_NIGHTMARE);
    }

    public void setPlayerLocationNightmare(int location) {
        this.playerLocationNightmare = location;
    }

    public int getPlayerLocationVoidChest() {
        return this.playerLocationVoidChest;
    }

    public static int getPlayerLocationVoidChestOffline(NBTTagCompound nbt) {
        return nbt.func_74775_l("ForgeData").func_74762_e(PLAYER_LOCATION_VOID_CHEST);
    }

    public void setPlayerLocationVoidChest(int location) {
        this.playerLocationVoidChest = location;
    }

    public NBTTagCompound getResearches() {
        return this.researches;
    }

    public void setReseraches(NBTTagCompound researches) {
        this.researches = researches;
    }

    public boolean isResearched(ResearchTypes research) {
        return this.getResearches().func_74767_n(RESEARCH_DATA + research.toString());
    }

    public boolean canResearch(ResearchTypes research) {
        return AOTDPlayerData.get(this.entityPlayer).getHasStartedAOTD() && !this.isResearched(research) && (research.getPrevious() == null || this.isResearched(research.getPrevious()));
    }

    public void unlockResearch(ResearchTypes research, boolean firstTimeResearched) {
        this.researches.func_74757_a(RESEARCH_DATA + research.toString(), true);
        if (!this.isServerSide() && firstTimeResearched) {
            ClientData.researchAchievedOverlay.displayResearch(research, new ItemStack((Item)ModItems.journal, 1), false);
            this.entityPlayer.func_85030_a("afraidofthedark:achievementUnlocked", 1.0f, 1.0f);
        }
        this.syncResearches();
    }

    public void syncResearches() {
        if (this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendTo(new UpdateResearch(this.researches), (EntityPlayerMP)this.entityPlayer);
        } else {
            AfraidOfTheDark.getPacketHandler().sendToServer(new UpdateResearch(this.researches));
        }
    }

    public boolean getHasBeatenEnaria() {
        return this.hasBeatenEnaria;
    }

    public void setHasBeatenEnaria(boolean hasBeatenEnaria) {
        this.hasBeatenEnaria = hasBeatenEnaria;
    }

    public void syncHasBeatenEnaria() {
        if (this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendTo(new UpdateHasBeatenEnaria(this.hasBeatenEnaria), (EntityPlayerMP)this.entityPlayer);
        }
    }

    public void setSelectedWristCrossbowBolt(int selectedWristCrossbowBolt) {
        this.selectedWristCrossbowBolt = selectedWristCrossbowBolt;
    }

    public int getSelectedWristCrossbowBolt() {
        return this.selectedWristCrossbowBolt;
    }

    public void syncSelectedWristCrossbowBolt() {
        if (!this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendToServer(new SyncSelectedWristCrossbowBolt(this.selectedWristCrossbowBolt));
        }
    }

    public SpellManager getSpellManager() {
        return this.spellManager;
    }

    public void syncSpellManager() {
    }

    public void syncAll() {
        if (this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendTo(new SyncAOTDPlayerData(this), (EntityPlayerMP)this.entityPlayer);
        }
    }

    public void requestSyncAll() {
        if (!this.isServerSide()) {
            AfraidOfTheDark.getPacketHandler().sendToServer(new SyncAOTDPlayerData());
        }
    }
}

