/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.packets;

import com.DavidM1A2.AfraidOfTheDark.common.handler.ConfigurationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.packets.minersBasicMessageHandler.MessageHandler;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.AOTDMeteorTypes;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.ResearchTypes;
import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDPlayerData;
import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import com.DavidM1A2.AfraidOfTheDark.common.worldGeneration.CreateMeteor;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SpawnMeteor
implements IMessage {
    private BlockPos thePosition;
    private int radius;
    private int height;
    private int index;

    public SpawnMeteor() {
        this.thePosition = null;
        this.radius = 0;
        this.height = 0;
        this.index = -1;
    }

    public SpawnMeteor(BlockPos thePosition, int radius, int height, int index) {
        this.thePosition = thePosition;
        this.radius = radius;
        this.height = height;
        this.index = index;
    }

    public void fromBytes(ByteBuf buf) {
        this.thePosition = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.radius = buf.readInt();
        this.height = buf.readInt();
        this.index = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.thePosition.func_177958_n());
        buf.writeInt(this.thePosition.func_177956_o());
        buf.writeInt(this.thePosition.func_177952_p());
        buf.writeInt(this.radius);
        buf.writeInt(this.height);
        buf.writeInt(this.index);
    }

    public static class Handler
    extends MessageHandler.Server<SpawnMeteor> {
        @Override
        public IMessage handleServerMessage(final EntityPlayer entityPlayer, final SpawnMeteor msg, MessageContext ctx) {
            MinecraftServer.func_71276_C().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (ConfigurationHandler.debugMessages) {
                        LogHelper.info("Player has requested to place a meteor at " + msg.thePosition.toString());
                    }
                    AOTDMeteorTypes typeToSpawn = AOTDMeteorTypes.typeFromIndex(msg.index);
                    if (AOTDPlayerData.get(entityPlayer).isResearched(ResearchTypes.AstronomyII)) {
                        CreateMeteor.create(entityPlayer.field_70170_p, msg.thePosition, msg.radius, msg.height, false, true, typeToSpawn);
                    } else if (AOTDPlayerData.get(entityPlayer).isResearched(ResearchTypes.AstronomyI.getPrevious()) && typeToSpawn == AOTDMeteorTypes.silver) {
                        CreateMeteor.create(entityPlayer.field_70170_p, msg.thePosition, msg.radius, msg.height, false, true, typeToSpawn);
                    }
                }
            });
            return null;
        }
    }
}

