/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.item;

import com.DavidM1A2.AfraidOfTheDark.AfraidOfTheDark;
import com.DavidM1A2.AfraidOfTheDark.common.item.core.AOTDItemWithCooldownPerItem;
import com.DavidM1A2.AfraidOfTheDark.common.packets.SyncFlaskOfSouls;
import com.DavidM1A2.AfraidOfTheDark.common.refrence.ResearchTypes;
import com.DavidM1A2.AfraidOfTheDark.common.savedData.AOTDPlayerData;
import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFlaskOfSouls
extends AOTDItemWithCooldownPerItem {
    public static Map<String, Integer> flaskKillRequirements = new HashMap<String, Integer>();
    public static final String FLASK_TYPE = "flaskType";
    public static final String KILLS = "flaskKills";

    public ItemFlaskOfSouls() {
        this.func_77655_b("flaskOfSouls");
        this.func_77625_d(1);
    }

    public boolean func_180614_a(ItemStack itemStack, EntityPlayer entityPlayer, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        int blockX = pos.func_177958_n();
        int blockY = pos.func_177956_o();
        int blockZ = pos.func_177952_p();
        if (world.field_72995_K) {
            return true;
        }
        if (AOTDPlayerData.get(entityPlayer).isResearched(ResearchTypes.PhylacteryOfSouls)) {
            double y = 0.0;
            if (world.func_180495_p(pos).func_177230_c().func_149686_d()) {
                y = 1.0;
            }
            if (this.spawnEntity(world, (double)blockX + 0.5, (double)blockY + y, (double)blockZ + 0.5, itemStack, entityPlayer) == null) {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Flask is incomplete or on cooldown."));
            }
        } else {
            entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("I'm not sure how to operate this."));
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (world.field_72995_K) {
            return itemStack;
        }
        if (AOTDPlayerData.get(entityPlayer).isResearched(ResearchTypes.PhylacteryOfSouls)) {
            MovingObjectPosition movingObjectPosition = this.func_77621_a(world, entityPlayer, true);
            if (movingObjectPosition == null) {
                return itemStack;
            }
            if (movingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                BlockPos thisPos = entityPlayer.func_180425_c();
                if (!world.canMineBlockBody(entityPlayer, thisPos)) {
                    return itemStack;
                }
                if (world.func_180495_p(thisPos) instanceof BlockLiquid && this.spawnEntity(world, thisPos.func_177958_n(), thisPos.func_177956_o(), thisPos.func_177952_p(), itemStack, entityPlayer) == null) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Flask is incomplete or on cooldown."));
                }
            }
            return itemStack;
        }
        entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("I'm not sure how to operate this."));
        return itemStack;
    }

    private Entity spawnEntity(World world, double x, double y, double z, ItemStack itemStack, EntityPlayer entityPlayer) {
        EntityLiving entityToSpawn = null;
        if (!world.field_72995_K && flaskKillRequirements.containsKey(NBTHelper.getString(itemStack, FLASK_TYPE)) && itemStack.func_77952_i() == 1 && !this.isOnCooldown(itemStack)) {
            String entityToSpawnName = NBTHelper.getString(itemStack, FLASK_TYPE);
            String aotdEntity = "AfraidOfTheDark." + entityToSpawnName.substring(6, 7).toLowerCase() + entityToSpawnName.substring(7);
            if (EntityList.field_75625_b.containsKey(entityToSpawnName)) {
                entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)entityToSpawnName, (World)world);
            } else if (EntityList.field_75625_b.containsKey(aotdEntity)) {
                entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)aotdEntity, (World)world);
            } else if (EntityList.field_75625_b.containsKey(entityToSpawnName.substring(6))) {
                entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)entityToSpawnName.substring(6), (World)world);
            } else {
                entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("The entity: " + entityToSpawnName + " is not supported by flasks at this time."));
            }
            if (entityToSpawn != null) {
                entityToSpawn.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                world.func_72838_d((Entity)entityToSpawn);
                entityToSpawn.func_70642_aH();
                this.setOnCooldown(itemStack);
                AfraidOfTheDark.getPacketHandler().sendTo(new SyncFlaskOfSouls(System.currentTimeMillis()), (EntityPlayerMP)entityPlayer);
            }
        }
        return entityToSpawn;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List tooltip, boolean advanced) {
        if (AOTDPlayerData.get(entityPlayer).isResearched(ResearchTypes.PhylacteryOfSouls)) {
            if (NBTHelper.getString(itemStack, FLASK_TYPE).equals("")) {
                tooltip.add("Flask unbound.");
                tooltip.add("Hold this in your hotbar while");
                tooltip.add("killing a mob to bind this flask.");
            } else {
                tooltip.add("Entity bound to: " + NBTHelper.getString(itemStack, FLASK_TYPE).substring(6));
                tooltip.add("Entity kills: " + NBTHelper.getInt(itemStack, KILLS) + "/" + flaskKillRequirements.get(NBTHelper.getString(itemStack, FLASK_TYPE)));
            }
        } else {
            tooltip.add("I'm not sure how to use this.");
        }
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (itemStack.func_77952_i() == 0) {
            if (NBTHelper.getString(itemStack, FLASK_TYPE).equals("")) {
                return 1.0;
            }
            return 1.0 - (double)NBTHelper.getInt(itemStack, KILLS) / (double)flaskKillRequirements.get(NBTHelper.getString(itemStack, FLASK_TYPE)).intValue();
        }
        return super.getDurabilityForDisplay(itemStack);
    }

    @Override
    public int getItemCooldownInTicks(ItemStack itemStack) {
        String type = NBTHelper.getString(itemStack, FLASK_TYPE);
        if (flaskKillRequirements.containsKey(type)) {
            if (flaskKillRequirements.get(type) == 32) {
                return 160;
            }
            if (flaskKillRequirements.get(type) == 16) {
                return 600;
            }
            return 1200;
        }
        return 160;
    }

    @Override
    public int getItemCooldownInTicks() {
        return 160;
    }

    static {
        flaskKillRequirements.put("EntityBat", 32);
        flaskKillRequirements.put("EntityChicken", 32);
        flaskKillRequirements.put("EntityCow", 32);
        flaskKillRequirements.put("EntityMooshroom", 32);
        flaskKillRequirements.put("EntityPig", 32);
        flaskKillRequirements.put("EntityRabbit", 32);
        flaskKillRequirements.put("EntitySheep", 32);
        flaskKillRequirements.put("EntitySquid", 32);
        flaskKillRequirements.put("EntityVillager", 8);
        flaskKillRequirements.put("EntityCaveSpider", 32);
        flaskKillRequirements.put("EntityEnderman", 16);
        flaskKillRequirements.put("EntitySpider", 32);
        flaskKillRequirements.put("EntityPigZombie", 16);
        flaskKillRequirements.put("EntityBlaze", 16);
        flaskKillRequirements.put("EntityCreeper", 32);
        flaskKillRequirements.put("EntityGuardian", 32);
        flaskKillRequirements.put("EntityEndermite", 32);
        flaskKillRequirements.put("EntityGhast", 8);
        flaskKillRequirements.put("EntityMagmaCube", 16);
        flaskKillRequirements.put("EntitySilverfish", 32);
        flaskKillRequirements.put("EntitySkeleton", 32);
        flaskKillRequirements.put("EntitySlime", 16);
        flaskKillRequirements.put("EntityWitch", 16);
        flaskKillRequirements.put("EntityZombie", 32);
        flaskKillRequirements.put("EntityHorse", 16);
        flaskKillRequirements.put("EntityOcelot", 32);
        flaskKillRequirements.put("EntityWolf", 16);
        flaskKillRequirements.put("EntityIronGolem", 8);
        flaskKillRequirements.put("EntitySnowman", 32);
        flaskKillRequirements.put("EntityWerewolf", 8);
        flaskKillRequirements.put("EntityDeeeSyft", 8);
        flaskKillRequirements.put("EntityEnchantedSkeleton", 32);
    }
}

