/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.handler;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static int biomeErieID;
    public static int biomeVoidChestID;
    public static int biomeNightmareID;
    public static int erieBiomeFrequency;
    public static float dungeonFrequencyMultiplier;
    public static float cryptFrequency;
    public static float darkForestFrequency;
    public static float gnomishCityFrequency;
    public static float springFrequency;
    public static float voidChestFrequency;
    public static float witchHutFrequency;
    public static boolean debugMessages;
    public static boolean enableAOTDAnimations;
    public static boolean enableWorldGenLightUpdates;

    public static void initializataion(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("AfraidOfTheDark")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        configuration.addCustomCategoryComment("Biome IDs", "Here you can configure Afraid of the Dark biome IDs");
        configuration.addCustomCategoryComment("Dungeon Frequency", "Here you can set how frequently certain dungeons appear.");
        biomeErieID = configuration.getInt("biomeErieID", "Biome IDs", 68, 5, 255, "The Biome ID for the erie forest. Use this to make this mod compatable with other biome mods.");
        biomeNightmareID = configuration.getInt("biomeNightmareID", "Biome IDs", 69, 5, 255, "The Biome ID for the nightmare. Use this to make this mod compatable with other biome mods.");
        biomeVoidChestID = configuration.getInt("biomeVoidChestID", "Biome IDs", 70, 5, 255, "The Biome ID for the Void Chest. Use this to make this mod compatable with other biome mods.");
        erieBiomeFrequency = configuration.getInt("erieBiomeFrequency", "general", 10, 0, 1000, "Increase this value to increase the number of Erie Biomes. 10 is the default MC forest value.");
        dungeonFrequencyMultiplier = configuration.getFloat("dungeonFrequencyMultiplier", "Dungeon Frequency", 1.0f, 0.0f, 1000.0f, "The dungeon frequency multiplier increases or decreases dungeon rarity across ALL Afraid of the Dark dungeons. (ex. 2.0 would result in double the dungeons and 0.5 in half)");
        cryptFrequency = configuration.getFloat("cryptFrequency", "Dungeon Frequency", 0.5f, 0.0f, 100.0f, "This property is the percentage chance per chunk that a crypt will spawn.");
        darkForestFrequency = configuration.getFloat("darkForestFrequency", "Dungeon Frequency", 0.4f, 0.0f, 100.0f, "This property is the percentage chance per chunk that a dark forest will spawn.");
        gnomishCityFrequency = configuration.getFloat("gnomishCityFrequency", "Dungeon Frequency", 0.4f, 0.0f, 100.0f, "This property is the percentage chance per chunk that a gnomish city will spawn.");
        springFrequency = configuration.getFloat("springFrequency", "Dungeon Frequency", 0.32f, 0.0f, 100.0f, "This property is the percentage chance per chunk that a spring will spawn.");
        voidChestFrequency = configuration.getFloat("voidChestFrequency", "Dungeon Frequency", 0.24f, 0.0f, 100.0f, "This property is the percentage chance per chunk that a void chest will spawn.");
        witchHutFrequency = configuration.getFloat("witchHutFrequency", "Dungeon Frequency", 0.8f, 0.0f, 100.0f, "This property is the percentage chance per chunk that a witch hut will spawn.");
        debugMessages = configuration.getBoolean("debugMessages", "general", false, "If you wish to receive all possible kinds of spammy debug messages in the console turn this on. Mostly used for developers only.");
        enableAOTDAnimations = configuration.getBoolean("enableAOTDEntityAnimations", "general", true, "Disable this to remove all animations from entities in the Afraid of the Dark mod. This may improve performance but mod entities will no longer have animations.");
        enableWorldGenLightUpdates = configuration.getBoolean("enableWorldGenLightUpdates", "general", false, "Enabling this will decrease world generation performance but decrease the chance of lighting glitches in AOTD dungeons.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    static {
        biomeErieID = 68;
        biomeVoidChestID = 69;
        biomeNightmareID = 70;
        erieBiomeFrequency = 10;
        dungeonFrequencyMultiplier = 1.0f;
        cryptFrequency = 0.5f;
        darkForestFrequency = 0.4f;
        gnomishCityFrequency = 0.4f;
        springFrequency = 0.32f;
        voidChestFrequency = 0.24f;
        witchHutFrequency = 0.8f;
        debugMessages = false;
        enableAOTDAnimations = true;
        enableWorldGenLightUpdates = false;
    }
}

