/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.entities.spell.projectile;

import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.animation.AnimationHandler;
import com.DavidM1A2.AfraidOfTheDark.common.entities.spell.EntitySpell;
import com.DavidM1A2.AfraidOfTheDark.common.entities.spell.projectile.AnimationHandlerSpellProjectile;
import com.DavidM1A2.AfraidOfTheDark.common.spell.Spell;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpellProjectile
extends EntitySpell {
    private AnimationHandler animHandler = new AnimationHandlerSpellProjectile(this);
    private int tileX = -1;
    private int tileY = -1;
    private int tileZ = -1;
    private Block insideOf;
    private boolean useStandardAI;
    public EntityLivingBase shootingEntity;

    public EntitySpellProjectile(Spell callback, int spellStageIndex, double x, double y, double z, double xVelocity, double yVelocity, double zVelocity, boolean useStandardAI) {
        super(callback.getSpellOwner().field_70170_p, callback, spellStageIndex);
        this.shootingEntity = callback.getSpellOwner();
        this.useStandardAI = useStandardAI;
        if (this.useStandardAI) {
            this.func_70012_b(x, y, z, this.shootingEntity.field_70177_z, this.shootingEntity.field_70125_A);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            double d3 = MathHelper.func_76133_a((double)(xVelocity * xVelocity + yVelocity * yVelocity + zVelocity * zVelocity));
            this.field_70159_w = xVelocity / d3 * 0.4;
            this.field_70181_x = yVelocity / d3 * 0.4;
            this.field_70179_y = zVelocity / d3 * 0.4;
        } else {
            this.func_70012_b(x, y, z, this.shootingEntity.field_70177_z, this.shootingEntity.field_70125_A);
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70159_w = 0.0;
            this.field_70181_x = 1.0;
            this.field_70179_y = 0.0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    @Override
    public AnimationHandler getAnimationHandler() {
        return this.animHandler;
    }

    @Override
    protected void updateSpellSpecificLogic() {
        if (!this.animHandler.isAnimationActive("Idle")) {
            this.animHandler.activateAnimation("Idle", 0.0f);
        }
        if (!this.field_70170_p.field_72995_K && (this.shootingEntity != null && this.shootingEntity.field_70128_L || !this.field_70170_p.func_175667_e(new BlockPos((Entity)this)))) {
            this.func_70106_y();
        } else {
            if (!this.useStandardAI) {
                if (this.getTicksAlive() == 60) {
                    EntityLivingBase closestEntity = null;
                    for (Object entity : this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(30.0, 30.0, 30.0))) {
                        if (!(entity instanceof EntityLivingBase) || entity instanceof EntityArmorStand) continue;
                        EntityLivingBase entityLiving = (EntityLivingBase)entity;
                        if (closestEntity != null && !(this.func_70032_d((Entity)entityLiving) < this.func_70032_d((Entity)closestEntity))) continue;
                        closestEntity = entityLiving;
                    }
                    if (closestEntity != null) {
                        double xVelocity = closestEntity.field_70165_t - this.field_70165_t;
                        double yVelocity = closestEntity.func_174813_aQ().field_72338_b + (double)(closestEntity.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
                        double zVelocity = closestEntity.field_70161_v - this.field_70161_v;
                        this.field_70159_w = xVelocity / 20.0;
                        this.field_70181_x = yVelocity / 20.0;
                        this.field_70179_y = zVelocity / 20.0;
                    } else {
                        this.performEffect(this.func_180425_c());
                        this.func_70106_y();
                    }
                } else if (this.getTicksAlive() > 60) {
                    this.performHitDetection();
                }
            } else {
                this.performHitDetection();
            }
            if (!this.field_70128_L) {
                this.field_70165_t += this.field_70159_w;
                this.field_70163_u += this.field_70181_x;
                this.field_70161_v += this.field_70179_y;
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            }
        }
    }

    private void performHitDetection() {
        Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3, vec31);
        vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec31 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1.func_70028_i((Entity)this.shootingEntity)) continue;
            float f = 0.3f;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
            MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(vec3, vec31);
            if (movingobjectposition1 == null || !((d1 = vec3.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            this.onImpact(movingobjectposition);
        }
    }

    public void onImpact(MovingObjectPosition movingObjectPosition) {
        if (!this.field_70170_p.field_72995_K) {
            switch (movingObjectPosition.field_72313_a) {
                case BLOCK: {
                    this.performEffect(new BlockPos(movingObjectPosition.field_72307_f));
                    break;
                }
                case ENTITY: {
                    this.performEffect(movingObjectPosition.field_72308_g);
                    break;
                }
                case MISS: {
                    break;
                }
            }
            this.spellStageComplete();
            this.func_70106_y();
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74777_a("xTile", (short)this.tileX);
        tagCompound.func_74777_a("yTile", (short)this.tileY);
        tagCompound.func_74777_a("zTile", (short)this.tileZ);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.insideOf);
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
    }

    @Override
    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.tileX = tagCompund.func_74765_d("xTile");
        this.tileY = tagCompund.func_74765_d("yTile");
        this.tileZ = tagCompund.func_74765_d("zTile");
        this.insideOf = tagCompund.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        if (tagCompund.func_150297_b("direction", 9)) {
            NBTTagList nbttaglist = tagCompund.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        } else {
            this.func_70106_y();
        }
    }

    @Override
    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    @Override
    public int getSpellLifeInTicks() {
        return 400;
    }

    @Override
    public float getSpellEntityWidth() {
        return 0.4f;
    }

    @Override
    public float getSpellEntityHeight() {
        return 0.4f;
    }
}

