/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.common.entities.spell;

import com.DavidM1A2.AfraidOfTheDark.common.MCACommonLibrary.IMCAnimatedEntity;
import com.DavidM1A2.AfraidOfTheDark.common.spell.Spell;
import com.DavidM1A2.AfraidOfTheDark.common.spell.effects.IEffect;
import com.DavidM1A2.AfraidOfTheDark.common.utility.LogHelper;
import com.DavidM1A2.AfraidOfTheDark.common.utility.NBTObjectWriter;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public abstract class EntitySpell
extends Entity
implements IMCAnimatedEntity {
    private static final String SPELL_SOURCE = "spellSource";
    private Spell spellSource;
    private static final String SPELL_STAGE_KEY = "spellStageIndex";
    private int spellStageIndex;
    private static final String SPELL_TICKS_ALIVE = "spellTicksAlive";
    private int ticksAlive;
    private static final String SPELL_COLOR = "spellColor";
    private float[] color = new float[4];

    public EntitySpell(World world, Spell callback, int spellStageIndex) {
        super(world);
        this.color[3] = 1.0f;
        this.color[2] = 1.0f;
        this.color[1] = 1.0f;
        this.color[0] = 1.0f;
        this.spellSource = callback;
        this.spellStageIndex = spellStageIndex;
        this.func_70105_a(this.getSpellEntityWidth(), this.getSpellEntityHeight());
    }

    public void func_70030_z() {
        super.func_70030_z();
        ++this.ticksAlive;
        if (this.ticksAlive >= this.getSpellLifeInTicks()) {
            this.spellStageComplete();
            this.func_70106_y();
        } else {
            this.updateSpellSpecificLogic();
        }
    }

    protected void func_70088_a() {
    }

    protected abstract void updateSpellSpecificLogic();

    protected void func_70037_a(NBTTagCompound compound) {
        this.spellStageIndex = compound.func_74762_e(SPELL_STAGE_KEY);
        this.spellSource = (Spell)NBTObjectWriter.readObjectFromNBT(SPELL_SOURCE, compound);
        this.ticksAlive = compound.func_74762_e(SPELL_TICKS_ALIVE);
        this.color[0] = compound.func_74760_g("spellColorr");
        this.color[1] = compound.func_74760_g("spellColorg");
        this.color[2] = compound.func_74760_g("spellColorb");
        this.color[3] = compound.func_74760_g("spellColora");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a(SPELL_STAGE_KEY, this.spellStageIndex);
        NBTObjectWriter.writeObjectToNBT(SPELL_SOURCE, this.spellSource, compound);
        compound.func_74768_a(SPELL_TICKS_ALIVE, this.ticksAlive);
        compound.func_74776_a("spellColorr", this.color[0]);
        compound.func_74776_a("spellColorg", this.color[1]);
        compound.func_74776_a("spellColorb", this.color[2]);
        compound.func_74776_a("spellColora", this.color[3]);
    }

    public void spellStageComplete() {
        ++this.spellStageIndex;
        if (!this.spellSource.hasSpellStage(this.spellStageIndex)) {
            LogHelper.info("Entity spell: Spell over");
            return;
        }
        this.field_70170_p.func_72838_d((Entity)this.getSpellSource().getSpellStageByIndex(this.spellStageIndex).getKey().createSpellEntity(this, this.spellStageIndex));
    }

    public void performEffect(BlockPos location) {
        for (IEffect effect : this.getSpellSource().getSpellStageByIndex(this.getSpellStageIndex()).getValue()) {
            effect.performEffect(location, this.field_70170_p);
        }
    }

    public void performEffect(Entity entity) {
        for (IEffect effect : this.getSpellSource().getSpellStageByIndex(this.getSpellStageIndex()).getValue()) {
            effect.performEffect(entity);
        }
    }

    public boolean func_70067_L() {
        return false;
    }

    public int getTicksAlive() {
        return this.ticksAlive;
    }

    public Spell getSpellSource() {
        return this.spellSource;
    }

    public int getSpellStageIndex() {
        return this.spellStageIndex;
    }

    public void setSpellColor(float r, float g, float b, float a) {
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
        this.color[3] = a;
    }

    public float[] getSpellColor() {
        return this.color;
    }

    public abstract float getSpellEntityWidth();

    public abstract float getSpellEntityHeight();

    public abstract int getSpellLifeInTicks();
}

