/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls;

import net.minecraft.util.MathHelper;

public class SpriteSheetController {
    private final int frameDelayInMillis;
    private final int totalFrames;
    private final int frameWidth;
    private final int frameHeight;
    private final boolean frameInterpolate;
    private final boolean isVertical;
    private float percentageTowardsNextFrame = 0.0f;
    private long lastFrameTime = 0L;
    private int currentFrame = 0;
    private int nextFrame = 0;

    public SpriteSheetController(int frameDelayInMillis, int totalFrames, int frameWidth, int frameHeight, boolean frameInterpolate, boolean isVertical) {
        this.frameDelayInMillis = frameDelayInMillis;
        this.totalFrames = totalFrames;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.frameInterpolate = frameInterpolate;
        this.isVertical = isVertical;
    }

    public void performUpdate() {
        if (System.currentTimeMillis() - this.lastFrameTime > (long)this.frameDelayInMillis) {
            this.lastFrameTime = System.currentTimeMillis();
            ++this.currentFrame;
            this.nextFrame = this.currentFrame + 1;
            if (this.currentFrame > this.totalFrames - 1) {
                this.currentFrame = 0;
            } else if (this.currentFrame > this.totalFrames - 2) {
                this.nextFrame = 0;
            }
        }
        this.percentageTowardsNextFrame = MathHelper.func_76131_a((float)(1.0f - (float)(System.currentTimeMillis() - this.lastFrameTime) / (float)this.frameDelayInMillis), (float)0.0f, (float)1.0f);
    }

    public boolean frameInterpolate() {
        return this.frameInterpolate;
    }

    public float getPercentageTowardsNextFrame() {
        return this.percentageTowardsNextFrame;
    }

    public boolean spriteSheetIsVertical() {
        return this.isVertical;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameHeight() {
        return this.frameWidth;
    }

    public int getCurrentFrame() {
        return this.currentFrame;
    }

    public int getNextFrame() {
        return this.nextFrame;
    }

    public int getTotalFrames() {
        return this.totalFrames;
    }
}

