/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls;

import com.DavidM1A2.AfraidOfTheDark.client.gui.AOTDActionListener;
import com.DavidM1A2.AfraidOfTheDark.client.gui.AOTDGuiUtility;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiComponent;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiImage;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiLabel;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiPanel;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiTextComponent;
import com.DavidM1A2.AfraidOfTheDark.client.trueTypeFont.TrueTypeFont;
import java.awt.Color;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.MathHelper;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class AOTDGuiTextField
extends AOTDGuiTextComponent {
    private final AOTDGuiImage background;
    private final AOTDGuiPanel textContainer;
    private final AOTDGuiLabel textField;
    private boolean isFocused = false;
    private String ghostText = "";
    private float[] originalTextColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public AOTDGuiTextField(int x, int y, int width, int height, TrueTypeFont font) {
        super(x, y, width, height, font);
        Keyboard.enableRepeatEvents((boolean)true);
        this.background = new AOTDGuiImage(0, 0, width, height, "afraidofthedark:textures/gui/textFieldBackground.png");
        this.textContainer = new AOTDGuiPanel(5, 5, width - 10, height - 10, true);
        this.textField = new AOTDGuiLabel(0, 0, font);
        this.textContainer.add(this.textField);
        this.add(this.background);
        this.add(this.textContainer);
        this.addActionListener(new AOTDActionListener(){

            @Override
            public void actionPerformed(AOTDGuiComponent component, AOTDActionListener.ActionType actionType) {
                if (component == AOTDGuiTextField.this) {
                    AOTDGuiTextField current = AOTDGuiTextField.this;
                    if (actionType == AOTDActionListener.ActionType.MousePressed) {
                        if (current.isHovered()) {
                            current.setFocused(true);
                        } else {
                            current.setFocused(false);
                        }
                    } else if (actionType == AOTDActionListener.ActionType.KeyTyped) {
                        current.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
                    }
                }
            }
        });
    }

    public void keyTyped(char character, int keyCode) {
        if (this.isFocused() && (!AOTDGuiUtility.isCtrlKeyDown() || keyCode != 30)) {
            if (AOTDGuiUtility.isCtrlKeyDown() && keyCode == 46) {
                AOTDGuiUtility.setClipboardString(this.getText());
            } else if (AOTDGuiUtility.isCtrlKeyDown() && keyCode == 47) {
                this.setText("");
                this.addText(ChatAllowedCharacters.func_71565_a((String)AOTDGuiUtility.getClipboardString()));
            } else if (AOTDGuiUtility.isCtrlKeyDown() && keyCode == 45) {
                AOTDGuiUtility.setClipboardString(this.getText());
                this.setText("");
            } else {
                switch (keyCode) {
                    case 14: {
                        this.removeChars(1);
                        break;
                    }
                    case 203: {
                        break;
                    }
                    case 205: {
                        break;
                    }
                    default: {
                        if (!ChatAllowedCharacters.func_71566_a((char)character)) break;
                        this.addText(Character.toString(character));
                    }
                }
            }
        }
    }

    private void removeChars(int number) {
        number = MathHelper.func_76125_a((int)number, (int)0, (int)this.getText().length());
        this.setText(this.getText().substring(0, this.getText().length() - number).concat("_"));
    }

    private void addText(String text) {
        text = ChatAllowedCharacters.func_71565_a((String)text);
        this.setText(this.getText().concat(text + "_"));
    }

    private void updateAmountOfScroll() {
        float textWidth = this.getFont().getWidth(this.getRawText()) * this.textScaleConstant * 0.966f;
        if (textWidth > (float)(this.textContainer.getWidth() - this.textContainer.getXWithoutParentTransform())) {
            this.textField.setX((int)((float)(this.textField.getParent().getX() + this.textField.getParent().getWidth()) - textWidth - (float)this.textContainer.getXWithoutParentTransform()) - 5);
        } else {
            this.textField.setX(this.textField.getParent().getX() - 5);
        }
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            super.draw();
        }
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.textField.setText(text);
        this.updateAmountOfScroll();
    }

    @Override
    public String getText() {
        String text = this.getRawText();
        return text.length() == 0 ? "" : (text.charAt(text.length() - 1) == '_' ? text.substring(0, text.length() - 1) : text);
    }

    public String getRawText() {
        return super.getText();
    }

    public void setFocused(boolean isFocused) {
        boolean wasFocused = this.isFocused;
        this.isFocused = isFocused;
        if (!wasFocused && isFocused) {
            this.background.setColor(new Color(230, 230, 230));
            String text = this.getRawText();
            if (text == this.getGhostText()) {
                this.setText("_");
                this.textField.setTextColor(this.originalTextColor);
            } else {
                this.setText(text.concat("_"));
            }
        } else if (wasFocused && !isFocused) {
            this.background.setColor(Color.WHITE);
            String text = this.getRawText();
            if (StringUtils.isEmpty((CharSequence)this.getText())) {
                this.loadGhostText();
            } else {
                this.setText(text.charAt(text.length() - 1) == '_' ? text.substring(0, text.length() - 1) : text);
            }
        }
    }

    @Override
    public void setTextColor(Color color) {
        this.textField.setTextColor(color);
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setGhostText(String ghostText) {
        this.ghostText = ghostText;
        if (StringUtils.isEmpty((CharSequence)this.getText())) {
            this.loadGhostText();
        }
    }

    private void loadGhostText() {
        this.setText(this.ghostText);
        this.originalTextColor = this.textField.getTextColor();
        this.setTextColor(Color.gray);
    }

    public String getGhostText() {
        return this.ghostText;
    }
}

