/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls;

import com.DavidM1A2.AfraidOfTheDark.client.gui.AOTDGuiUtility;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.AOTDGuiPanel;
import com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls.SpriteSheetController;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class AOTDGuiScreen
extends GuiScreen {
    private double guiScale = 1.0;
    private final AOTDGuiPanel contentPane;
    protected final int INVENTORY_KEYCODE;
    protected final EntityPlayerSP entityPlayer;
    private List<SpriteSheetController> spriteSheetControllers;
    protected final FontRenderer fontRenderer;

    public AOTDGuiScreen() {
        this.INVENTORY_KEYCODE = Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i();
        this.entityPlayer = Minecraft.func_71410_x().field_71439_g;
        this.spriteSheetControllers = new LinkedList<SpriteSheetController>();
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.contentPane = new AOTDGuiPanel(0, 0, 640, 360, false);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        AOTDGuiUtility.updateScaledResolution();
        this.field_146292_n.clear();
        double guiScaleX = (double)this.field_146294_l / 640.0;
        double guiScaleY = (double)this.field_146295_m / 360.0;
        this.guiScale = Math.min(guiScaleX, guiScaleY);
        this.getContentPane().setScaleXAndY(this.guiScale);
        if (guiScaleX < guiScaleY) {
            this.getContentPane().setX(0);
            this.getContentPane().setY((this.field_146295_m - this.getContentPane().getHeightScaled()) / 2);
        } else {
            this.getContentPane().setX((this.field_146294_l - this.getContentPane().getWidthScaled()) / 2);
            this.getContentPane().setY(0);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        for (SpriteSheetController sheetController : this.spriteSheetControllers) {
            sheetController.performUpdate();
        }
        GlStateManager.func_179147_l();
        if (this.drawGradientBackground()) {
            this.func_146276_q_();
        }
        this.getContentPane().draw();
        this.contentPane.update(mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179084_k();
    }

    public AOTDGuiPanel getContentPane() {
        return this.contentPane;
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        this.getContentPane().keyPressed();
        if (this.inventoryToCloseGuiScreen() && keyCode == this.INVENTORY_KEYCODE) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            GL11.glFlush();
        }
        super.func_73869_a(character, keyCode);
    }

    public void addSpriteSheetController(SpriteSheetController sheetController) {
        this.spriteSheetControllers.add(sheetController);
    }

    public void mouseInputEvent() {
        switch (Mouse.getEventButton()) {
            case 0: {
                if (Mouse.getEventButtonState()) {
                    this.contentPane.mousePressed();
                    break;
                }
                this.contentPane.mouseReleased();
                break;
            }
            case -1: {
                this.contentPane.mouseMove(AOTDGuiUtility.getMouseX(), AOTDGuiUtility.getMouseY());
            }
        }
    }

    public abstract boolean inventoryToCloseGuiScreen();

    public abstract boolean drawGradientBackground();
}

