/*
 * Decompiled with CFR 0.152.
 */
package com.DavidM1A2.AfraidOfTheDark.client.gui.baseControls;

import com.DavidM1A2.AfraidOfTheDark.client.gui.AOTDGuiUtility;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public abstract class AOTDGuiComponent {
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private boolean isHovered = false;
    private boolean isVisible = true;
    private Rectangle boundingBox = new Rectangle();
    private Rectangle scaledBoundingBox = new Rectangle();
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected final EntityPlayerSP entityPlayer;
    protected final FontRenderer fontRenderer;

    public AOTDGuiComponent(int x, int y, int width, int height) {
        this.entityPlayer = Minecraft.func_71410_x().field_71439_g;
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.boundingBox = new Rectangle(x, y, width, height);
    }

    public void draw() {
        GL11.glColor4d((double)this.getColor()[0], (double)this.getColor()[1], (double)this.getColor()[2], (double)this.getColor()[3]);
    }

    public void drawBoundingBox() {
        Gui.func_73734_a((int)this.getXScaled(), (int)this.getYScaled(), (int)(this.getXScaled() + this.getWidthScaled()), (int)(this.getYScaled() + 1), (int)-1);
        Gui.func_73734_a((int)this.getXScaled(), (int)this.getYScaled(), (int)(this.getXScaled() + 1), (int)(this.getYScaled() + this.getHeightScaled()), (int)-1);
        Gui.func_73734_a((int)(this.getXScaled() + this.getWidthScaled() - 1), (int)this.getYScaled(), (int)(this.getXScaled() + this.getWidthScaled()), (int)(this.getYScaled() + this.getHeightScaled()), (int)-1);
        Gui.func_73734_a((int)this.getXScaled(), (int)(this.getYScaled() + this.getHeightScaled() - 1), (int)(this.getXScaled() + this.getWidthScaled()), (int)(this.getYScaled() + this.getHeightScaled()), (int)-1);
        GlStateManager.func_179147_l();
    }

    public boolean intersects(AOTDGuiComponent other) {
        if (other == null) {
            return false;
        }
        return this.scaledBoundingBox.intersects(other.scaledBoundingBox);
    }

    public void setScaleXAndY(double scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScaleX(double scaleX) {
        this.scaleX = scaleX;
        this.updateScaledBounds();
    }

    public void setScaleY(double scaleY) {
        this.scaleY = scaleY;
        this.updateScaledBounds();
    }

    public void updateScaledBounds() {
        int xNew = (int)Math.round(this.scaleX * (double)this.boundingBox.x);
        int yNew = (int)Math.round(this.scaleY * (double)this.boundingBox.y);
        int widthNew = (int)Math.round(this.scaleX * (double)this.boundingBox.width);
        int heightNew = (int)Math.round(this.scaleY * (double)this.boundingBox.height);
        this.scaledBoundingBox.setBounds(xNew, yNew, widthNew, heightNew);
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setX(int x) {
        this.boundingBox.x = x;
        this.updateScaledBounds();
    }

    public int getXScaled() {
        return this.scaledBoundingBox.x;
    }

    public int getX() {
        return this.boundingBox.x;
    }

    public void setY(int y) {
        this.boundingBox.y = y;
        this.updateScaledBounds();
    }

    public int getYScaled() {
        return this.scaledBoundingBox.y;
    }

    public int getY() {
        return this.boundingBox.y;
    }

    public void setWidth(int width) {
        this.boundingBox.width = width;
        this.updateScaledBounds();
    }

    public int getWidthScaled() {
        return this.scaledBoundingBox.width;
    }

    public int getWidth() {
        return this.boundingBox.width;
    }

    public void setHeight(int height) {
        this.boundingBox.height = height;
        this.updateScaledBounds();
    }

    public int getHeightScaled() {
        return this.scaledBoundingBox.height;
    }

    public int getHeight() {
        return this.boundingBox.height;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isHovered() {
        return this.isHovered;
    }

    public void setHovered(boolean isHovered) {
        this.isHovered = isHovered;
    }

    public void setColor(Color color) {
        this.setColor(AOTDGuiUtility.convert255To01Color(color));
    }

    public void setColor(float[] color) {
        if (color.length != 4) {
            return;
        }
        this.color = color;
    }

    public float[] getColor() {
        return this.color;
    }

    public void brightenColor(float amount) {
        this.color[0] = MathHelper.func_76131_a((float)(this.color[0] + amount), (float)0.0f, (float)255.0f);
        this.color[1] = MathHelper.func_76131_a((float)(this.color[1] + amount), (float)0.0f, (float)255.0f);
        this.color[2] = MathHelper.func_76131_a((float)(this.color[2] + amount), (float)0.0f, (float)255.0f);
    }

    public void darkenColor(float amount) {
        this.color[0] = MathHelper.func_76131_a((float)(this.color[0] - amount), (float)0.0f, (float)255.0f);
        this.color[1] = MathHelper.func_76131_a((float)(this.color[1] - amount), (float)0.0f, (float)255.0f);
        this.color[2] = MathHelper.func_76131_a((float)(this.color[2] - amount), (float)0.0f, (float)255.0f);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " located at " + this.boundingBox + " with a scaled resolution of " + this.scaledBoundingBox;
    }
}

