/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.gen;

import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import net.gegy1000.earth.server.world.gen.DataMap;
import net.minecraft.world.biome.BiomeGenBase;

public class EarthGen {
    private DataMap heightmap;
    private DataMap biomemap;
    private static final String HEIGHTMAP_LOCATION = "/assets/earth/textures/heightmap/earth_heightmap.mchmap";
    private static final String BIOMEMAP_LOCATION = "/assets/earth/textures/heightmap/earth_biomemap.mcbmap";
    private static final double WORLD_SCALE = 10.0;
    private static final int WORLD_OFFSET_X = 21600;
    private static final int WORLD_OFFSET_Z = 10800;
    public static final BiomeGenBase DEFAULT_BIOME = BiomeGenBase.field_76771_b;

    public void load() throws IOException {
        if (this.heightmap == null) {
            this.loadHeightmap();
        }
        if (this.biomemap == null) {
            this.loadBiomemap();
        }
    }

    public void loadHeightmap() throws IOException {
        System.out.println("Loading Earth Heightmap...");
        this.heightmap = DataMap.construct(HEIGHTMAP_LOCATION, true);
    }

    public void loadBiomemap() throws IOException {
        System.out.println("Loading Earth Biomemap...");
        this.biomemap = DataMap.construct(BIOMEMAP_LOCATION, false);
    }

    public int getHeightForCoords(int x, int z) {
        int width = this.heightmap.getWidth();
        int height = this.biomemap.getHeight();
        int scaledWidth = (int)((double)width * 10.0);
        int scaledHeight = (int)((double)height * 10.0);
        x = (int)((double)x + 216000.0);
        z = (int)((double)z + 108000.0);
        double[][] buffer = new double[4][4];
        double xScaled = (double)x / (double)(scaledWidth - 1) * (double)(width - 1);
        double yScaled = (double)z / (double)(scaledHeight - 1) * (double)(height - 1);
        int xOrigin = (int)xScaled;
        int yOrigin = (int)yScaled;
        double xIntermediate = xScaled - (double)xOrigin;
        double yIntermediate = yScaled - (double)yOrigin;
        for (int u = 0; u < 4; ++u) {
            for (int v = 0; v < 4; ++v) {
                buffer[u][v] = this.getHeight(xOrigin - 1 + u, yOrigin - 1 + v);
            }
        }
        int value = (int)Math.round(Bicubic.bicubic(buffer, xIntermediate, yIntermediate));
        value = Math.min(255, Math.max(value, 0));
        return value;
    }

    public BiomeGenBase getBiomeForCoords(int x, int z) {
        int width = this.biomemap.getWidth();
        int height = this.biomemap.getHeight();
        int scaledWidth = (int)((double)width * 10.0);
        int scaledHeight = (int)((double)height * 10.0);
        x = (int)((double)x + 216000.0);
        z = (int)((double)z + 108000.0);
        if (x < 0 || z < 0 || x >= scaledWidth || z >= scaledHeight) {
            return DEFAULT_BIOME;
        }
        HashMultimap heightToBiome = HashMultimap.create();
        double[][] buffer = new double[4][4];
        double xScaled = (double)x / (double)(scaledWidth - 1) * (double)(width - 1);
        double yScaled = (double)z / (double)(scaledHeight - 1) * (double)(height - 1);
        int xOrigin = (int)xScaled;
        int yOrigin = (int)yScaled;
        double xIntermediate = xScaled - (double)xOrigin;
        double yIntermediate = yScaled - (double)yOrigin;
        BiomeGenBase prevBiome = null;
        boolean hasMultipleBiomes = false;
        for (int u = 0; u < 4; ++u) {
            for (int v = 0; v < 4; ++v) {
                int dataX = xOrigin - 1 + u;
                int dataY = yOrigin - 1 + v;
                int blockHeight = (int)this.getHeight(dataX, dataY);
                buffer[u][v] = blockHeight;
                BiomeGenBase biome = this.getBiome(dataX, dataY);
                if (prevBiome != null && !biome.equals(prevBiome)) {
                    hasMultipleBiomes = true;
                }
                heightToBiome.put((Object)blockHeight, (Object)biome.field_76756_M);
                prevBiome = biome;
            }
        }
        if (hasMultipleBiomes) {
            double interpolated = Bicubic.bicubic(buffer, xIntermediate, yIntermediate);
            double closestDistance = Double.POSITIVE_INFINITY;
            int closestHeight = 0;
            for (Map.Entry entry : heightToBiome.entries()) {
                int blockHeight = (Integer)entry.getKey();
                double diff = Math.abs((double)blockHeight - interpolated);
                if (!(diff < closestDistance)) continue;
                closestHeight = blockHeight;
                closestDistance = diff;
            }
            Object[] biomesForHeight = heightToBiome.get((Object)closestHeight).toArray();
            if (biomesForHeight.length != 1) {
                Random random = new Random(xOrigin * yOrigin);
                if (xIntermediate * xIntermediate + yIntermediate * yIntermediate + random.nextDouble() * 0.02 > 0.25) {
                    double phi = Math.atan2(yIntermediate, xIntermediate);
                    int dirPhi = (int)(Math.floor((phi + Math.PI) / (Math.PI * 2) * 8.0 + 0.5) % 8.0);
                    if (dirPhi == 8) {
                        dirPhi = 7;
                    }
                    if (dirPhi == 0 || dirPhi == 1 || dirPhi == 7) {
                        --xOrigin;
                    } else if (dirPhi == 3 || dirPhi == 4 || dirPhi == 5) {
                        ++xOrigin;
                    }
                    if (dirPhi == 1 || dirPhi == 2 || dirPhi == 3) {
                        --yOrigin;
                    } else if (dirPhi == 5 || dirPhi == 6 || dirPhi == 7) {
                        ++yOrigin;
                    }
                }
                return this.getBiome(xOrigin, yOrigin);
            }
            return BiomeGenBase.func_150565_n()[(Integer)biomesForHeight[0]];
        }
        return prevBiome;
    }

    public static double cubic(double[] p, double x) {
        return p[1] + 0.5 * x * (p[2] - p[0] + x * (2.0 * p[0] - 5.0 * p[1] + 4.0 * p[2] - p[3] + x * (3.0 * (p[1] - p[2]) + p[3] - p[0])));
    }

    public void clearCache() {
        this.heightmap.clearCache();
        this.biomemap.clearCache();
    }

    public double extractHeight(int x, int y) {
        if (x < 0 || x >= this.heightmap.getWidth() || y < 0 || y >= this.heightmap.getHeight()) {
            return 0.0;
        }
        return this.heightmap.getData(x, y);
    }

    public double getHeight(int x, int y) {
        return (int)(this.extractHeight(x, y) * 0.8 + 10.0);
    }

    public BiomeGenBase getBiome(int x, int y) {
        try {
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)this.biomemap.getData(x, y));
            if (biome == null) {
                biome = DEFAULT_BIOME;
            }
            return biome;
        }
        catch (Exception e) {
            e.printStackTrace();
            return DEFAULT_BIOME;
        }
    }

    public double toLat(double z) {
        return 90.0 - (z + 108000.0) / ((double)this.heightmap.getHeight() * 10.0) * 180.0;
    }

    public double toLong(double x) {
        return (x + 216000.0) / ((double)this.heightmap.getWidth() * 10.0) * 360.0 - 180.0;
    }

    public double fromLat(double lat) {
        int height = this.heightmap.getHeight();
        double scale = 10.0;
        double scaledZ = (double)height - (lat + 90.0) / 180.0 * (double)height;
        return (scaledZ - 10800.0) * scale;
    }

    public double fromLong(double longitude) {
        double scale = 10.0;
        double scaledX = (longitude + 180.0) / 360.0 * (double)this.heightmap.getWidth();
        return (scaledX - 21600.0) * scale;
    }

    private static class Bicubic {
        private static ThreadLocal<double[]> ARR_THREADSAFE = new ThreadLocal<double[]>(){

            @Override
            protected double[] initialValue() {
                return new double[4];
            }
        };

        private Bicubic() {
        }

        public static double bicubic(double[][] p, double x, double y) {
            double[] arr = ARR_THREADSAFE.get();
            arr[0] = EarthGen.cubic(p[0], y);
            arr[1] = EarthGen.cubic(p[1], y);
            arr[2] = EarthGen.cubic(p[2], y);
            arr[3] = EarthGen.cubic(p[3], y);
            return EarthGen.cubic(arr, x);
        }
    }
}

