/*
 * Decompiled with CFR 0.152.
 */
package net.gegy1000.earth.server.world.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class DataMap {
    private int width;
    private int height;
    private FileChannel fileChannel;
    private boolean byteOffset;
    private Map<Integer, Byte> dataCache = new HashMap<Integer, Byte>();

    private DataMap(int width, int height, FileChannel fileChannel, boolean byteOffset) {
        this.width = width;
        this.height = height;
        this.fileChannel = fileChannel;
        this.byteOffset = byteOffset;
    }

    public static DataMap construct(String resource, boolean byteOffset) throws IOException {
        InputStream in = DataMap.class.getResourceAsStream(resource);
        String[] resourceFiles = resource.split("/");
        String fileNameWithExtention = resourceFiles[resourceFiles.length - 1];
        String[] fileNameExtensionSplit = fileNameWithExtention.split(Pattern.quote("."));
        File heightmapFile = DataMap.createTempFile(fileNameExtensionSplit[0], fileNameExtensionSplit[1]);
        DataMap.copyFile(in, heightmapFile);
        RandomAccessFile randomAccessFile = new RandomAccessFile(heightmapFile, "r");
        FileChannel channel = randomAccessFile.getChannel();
        int width = DataMap.readInteger(0, channel);
        int height = DataMap.readInteger(4, channel);
        return new DataMap(width, height, channel, byteOffset);
    }

    public int getData(int x, int y) {
        try {
            int data;
            int position = this.width * y + x + 8;
            if (!this.dataCache.containsKey(position)) {
                data = DataMap.readByte(position, this.fileChannel);
                this.dataCache.put(position, (byte)data);
            } else {
                data = this.dataCache.get(position).byteValue();
            }
            if (this.byteOffset) {
                data += 128;
            }
            return Math.min(data, 255);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void clearCache() {
        this.dataCache.clear();
    }

    private static byte readByte(int position, FileChannel channel) throws IOException {
        channel.position(position);
        ByteBuffer buf = ByteBuffer.allocate(1);
        channel.read(buf);
        return buf.get(0);
    }

    private static int readInteger(int position, FileChannel channel) throws IOException {
        channel.position(position);
        ByteBuffer buf = ByteBuffer.allocate(4);
        channel.read(buf);
        return ByteBuffer.wrap(buf.array()).getInt();
    }

    private static void copyFile(InputStream in, File to) throws IOException {
        int n;
        if (!to.getParentFile().exists()) {
            to.getParentFile().mkdirs();
        }
        if (!to.exists()) {
            to.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(to);
        byte[] buffer = new byte[8024];
        while (-1 != (n = in.read(buffer))) {
            out.write(buffer, 0, n);
        }
        in.close();
        out.close();
    }

    private static File createTempFile(String suffix, String format) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File temp = new File(tempDir, "tempearthmod" + suffix + "." + format);
        if (!temp.exists() && !temp.createNewFile()) {
            throw new IOException("Could not create temp file: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

